Monitoring by overhearing poses unique challenges as previously discussed. However, it also offers unique opportunities for plan recognition. We had earlier stated our assumption that agents are truthful in their communications, and do not seek to deceive their teammates or the monitoring system, nor prevent overhearing in any way (e.g., encryption). This assumption is justified as the monitoring system is deployed by the operator of the monitored agents, or by an agent team-member. Failures of the team to coordinate (e.g., due to clock asynchrony or unintentional erroneous messages) will therefore cause corresponding failures in monitoring. However, we do not make additional assumptions about the messages beyond those that are made by the monitored agents themselves.

This assumption allows a plan-recognition system to treat observations with certainty:
When a message is overheard terminating plan X, the monitoring system can infer with certainty that indeed the plan X is no longer executed. However, this does not eliminate plan recognition ambiguity.  First, multiple instantiations of plan X may exist, and the message does not specify whi one was terminated. Second, upon termination of the plan, the monitored team-member must often choose between multiple alternative plan steps to follow X, and yet this choice is not evident in the observations.  Indeed, the difficulty of monitoring by overhearing is demonstrated by human monitoring performance: Novice human monitors have managed to only achieve approximately 60% accuracy on average.

## 3. Monitoring A Team Of Agents As Separate Individuals

In this section, we present a representation and associated baseline algorithms to support overhearing based on the plan-hierarchy and team-hierarchy. We begin by making an assumption of agent independence, where observations and beliefs about one agent's state of execution have no bearing on our beliefs about another agent's state. This assumption can be contrasted with another: If we assume instead that team-members are successful in their coordination, then knowing that one agent has begun executing a joint plan would naturally increase the likelihood that its teammates have begun as well, as agents would not be considered independent. In fact, successful teamwork requires interdependency among the agents (Grosz, 1996).

However, an initial assumption of agent independence provides a baseline of comparison, as it more closely follows current approaches to multi-agent plan recognition, which often assume that observations about each individual agent are continuously available.  Later sections (Sections 4 and 5) will highlight the unique challenges tackled in monitoring by overhearing, and will take agent interdependencies into account.

We thus begin by maintaining a separate plan recognizer for each agent. Each recognizer observes only those messages that its respective agent sends. On the basis of these observations, the recognizer maintains a probabilistic estimate of the state of execution of the various plans the agent may be currently executing. Knowledge of the plans assigned to agents and their team memberships is available in our application from the plan-hierarchy and team-hierarchy of the team-oriented program used in constructing the monitored appliction.

Section 3.1 presents the language we use for the probabilistic representation of a teamoriented program. We exploit various independence properties within team-oriented programs to achieve a compact representation of the possible plan states of the agents. Sec¬