
## 5.3  Pruning A Dc

The algorithm is a single-pass algorithm: each rule is tested only once, from the first rule to the last one. For each possible rule, a criterion Criterion(.) returns "TRUE" or
"FALSE" depending on whether the rule should be removed or not. There are two versions of this criterion. The first one, which we call "pessimistic", is based on conventional error minimization. The second one, called "optimistic", is derived from a previous work on pruning decision-trees (Kearns & Mansour, 1998).

## 5.3.1  Pessimistic Pruning

Pessimistic pruning builds a sequence of DC from the initial one. At each step, we remove one rule, such that its removal brings the lowest error among all possible removals of rule in the current DC. Each time the error of the current DC is not greater than the lowest error found already, Criterion(.) returns true for all rules already tested for removal. This pruning returns the smallest DC having the lowest error of the sequence. This pruning is rather natural (and simple), and motivated by the fact that the induction of the large DC
before pruning does not lead to a conventional error minimization. Such a property is rather seldom in "top-down and prune" induction algorithms. For example, common decision tree induction algorithms in this scheme incorporate very sophisticated pruning criteria (CART
(Breiman et al., 1984), C4.5 (Quinlan, 1994)).

## 5.3.2  Optimistic Pruning

Kearns & Mansour (1998) present a novel algorithm to prune decision trees, based on a test over locally observed errors. Its principle is simple: each internal node of a DT is tested only once in a bottom-up fashion, and we estimate the local error over the learning examples reaching this node, before and after the removal of the node. If the local error after removal is not greater than the local error before, plus a penalty term, then we remove the node and its subtree. The penalty term makes the pruning essentially optimistic, that is, we tend to overprune the decision tree. However, thanks to local uniform convergence results, and due to the fact that certain sub-classes of decision trees are reasonably large, Kearns & Mansour (1998) are able to prove that with high probability, the overpruning will not be too severe with respect to the optimal subtree of the initial DT. We refer the reader to their paper for further theoretical results, not needed here. The point is that by using the results of Kearns & Mansour (1998), we can obtain a similar test for DC. We emphasize that our bound might not enjoy the same theoretical properties as for decision trees, because of the cardinality reasons briefly outlined before. However, such a test is interesting since it may lead especially to very small and interpretable decision committees, with the obvious hope that their accuracy will not decrease too much. Furthermore, the per of Kearns & Mansour (1998) does not contain experimental results.  We think our criterion as a way to test heuristically the experimental feasibility of some of the results of Kearns & Mansour (1998). The principle of our criterion is exactly the same as the original test of Kearns & Mansour (1998) : "can we compare, when testing some rule ( t, v ) and using the examples that satisfy the rule, the errors before and after removing the rule"?

Let c(t,v) represent the error before removing the rule, on the local sample LS(t,v) satisfying monomial t. Denote ε α as the error before removing ( t, v ), still measured on the local sample