
## Proofsketch Of Theorem 5

The reduction is made from the NP-Hard problem 3SAT5 (Feige, 1996).  This is the classical 3SAT problem (Garey & Johnson, 1979), but each variable appears in exactly 5 clauses. Using a well-known reduction (Garey & Johnson, 1979), page 55, with an additional simple gadget, we can make a reduction from 3SAT5 to vertex cover (thus, independent set),
obtaining a graph G in which all vertices have degree either 5, or 0, and for which the largest independent set (for satisfiable instances of 3SAT5) has size |V|/2, where |V| is the number of vertices of G. From this particular graph, we build a simple reduction to our problem of maximizing Z . Note that since we are searching for an oblivious hypothesis, the observations are not important (we can suppose that all examples have the same observation). That is why the reduction only builds class vectors (over | V | classes), encoding the class membership of any of these identical observations. The idea is that the classes are in one-to-one mapping with the vertices, and there are two sets of class vectors built from G :
- a set with | V | vectors, encoding the vertices of G. Each one is a class vector with only

one "1" corresponding to the vertex, and the remaining components are zeroes.  Each of the corresponding examples have weight Wy.

- a set with | E | vectors, where | E | is the number of edges of G . Each one encodes an edge, and therefore contains two "1" (and the remaining are zeroes) corresponding to the two vertices of the edge. Each of the corresponding examples have weight We.
Consider formulas (2), (3) for example. They are the sum of the contribution to Z of the examples having weight W v , and the examples having weight W e . In these cases, we can rewrite Z using the generic expression:

$$Z=Z_{v}+Z_{e}\ ;\tag{23}$$ $$Z_{v}=W_{v}\ (e^{-\alpha}k(|V|-k)+k(k-1)+(|V|-k)(|V|-k-1)+e^{\alpha}k(|V|-k))\ \,$$ (24) $$Z_{e}=W_{e}\ (e^{-\alpha}(|V|-k)(2C+U)+e^{\alpha}k(2M+U))\ .\tag{25}$$
$$\begin{array}{l}{(\,23)}\\ {(\,24)}\\ {(\,25)}\end{array}$$

Here, C is the number of edges having their two vertices in the set corresponding to the
+1 values in v i , M is the number of edges having their two vertices in the set corresponding to the –1 values in v i , and U is the number of edges having one of their vertices in the +1 set, and the other one in the -1 set. k is the number of +1 values in vi.

Suppose that W v » W e ( e.g. W v > | V | 3 W e ). Then the maximization of Z is the maximization of Z v , followed by the maximization of Z e . Z v admits a maximum for k = | V | / 2 ,
and with this value for k , it can be shown that maximizing Z e boils down to maximize 2M + U, that is, the (weighted) number of edges not falling entirely into the set corresponding to the +1 values; whenever the 3SAT5 instance is satisfiable (and using the particular degrees of the vertices), this set corresponds to the largest independent set of G .

## Proof Of Lemma 1

The proof of this lemma is quite straightforward, but we give it for completeness.  Z can be rewritten as

$$\left(\,26\,\right)$$
$$Z\quad=\quad\sum_{j\,\neq\,k}Z_{j,k}\;\;,$$
