The values -1, 0, +1 allow natural interpretations of the rules, being either in favor of the corresponding class (+1), neutral with respect to the class (0), or in disfavor of the corresponding class (-1). This subclass, to which we relate as DC{-1.0,+1}, is, as we now prove, suffering the same algorithmic drawbacks as DT (Hyafil & Rivest, 1976) and DL (Nock & Jappy, 1998); even without restricting the components of the vectors, or with any restriction to a set containing at least one real value, the construction of small formulas with sufficiently high accuracy is hard. This is a clear motivation for using heuristics in decision committee's induction.

## 4. Building Small Accurate Decision Committees (And Alike) Is Hard

We now show that building decision committees is a hard algorithmic task when one strives to obtain both small and accurate formulas. There are two usual notions of size whi can nturally be used for decision committees. The first one is the whole number of literals of the formula (if a literal is present i times, it is counted i times) (Nock & Gascuel, 1995; Nock & Jappy, 1998), the second one is the number of rules of the formula (Kearns, Li, Pitt, & Valiant, 1987). Our results imply that regardless of the restriction over the values of the vectors (as long as they are elements of a set with cardinality ≥ 2), and already for two-classes problems, minimizing the size of a decision committee for both size definitions is as hard as solving well-known NP -Hard problems. Therefore, the task is also hard for DC{-1,0,+1} with the particular values -1, 0, +1 for the vectors.

## 4.1  The Size Of A Dc Is Measured As Its Whole Number Of Literals

Theorem 1  When the size of a DC is measured as its whole number of literals, it is NP-
Hard to find the smallest decision committee consistent with a set of examples LS.

Proof:  See the Appendix.

We can easily adapt Theorem 1 to the case where the rules are replaced by weighted DT as advocated in boosted C4.5 (Schapire & Singer, 1998).  Here, each tree returns a class E {+1, –1}, and each tree is given a real weight to leverage its vote. The sign of the linear combination gives the class of an example. The following theorem holds again with any limitations on the leveraging coefficients (as long as at least one non-zero value is authorized), or without limitation on the coefficients. By this, we mean that for each of the applicable limitations (or without), the problem is NP -Hard. The size notion is the sum, over all trees, of their number of nodes.

Theorem 2  It is NP-Hard to find the smallest weighted linear combinations of DT consistent with a set of examples LS, without limitation on the leveraging coefficients, or for any possible limitation, as long as at least one non-zero value is authorized.

While it is well known that boosting results in a rapid decreasing of the error over LS
which can easily and rapidly drop down to zero (as long as it is possible), Theorem 2 shows that attempts to efficiently reduce the size of the vote when boosting DT is NP-Hard. If the problem is simplified to the to pruning of a large consistent vote of DT (Margineantu & Dietterich, 1997), to obtain a smaller consistent (or with limited error) vote with restricted size, it is again possible (using the same reduction) to show that this brings NP-Hardness.