
## 5.2  Calculating Rule Vectors Using Ranking Loss Boosting

Schapire & Singer (1998) have investigated classification problems where the aim of the procedure is not to provide an accurate class for some observation. Rather, the algorithm outputs a set of values (one for each class) and we expect the class of the observation to receive the largest value of all, thus being ranked higher than all others. This approach is particularly useful when a given example can belong to more than one class (multilabel problems), a case where we expect each of these classes to receive the greatest values compared to the classes the examples does not belong to.

The ranking loss represents informally the number of times the hypothesis fails to rank the class of an example higher than a class to which it does not belong. Before going further, we first generalize our classification setting, and replace the common notation ( σ, c o ) for an example by the more general one ( o, co ). Here, co E {0, 1} c is a vector giving, for each class, the membership to the class ("0" is no and "1" is yes) of the corresponding observation o .

It is important to note that this setting is more general than the usual Bayesian setting, in which there can exist examples ( o,c o ) and ( o ′ ,c o ′ ) (using the non-vector notation) for which o = o' but c o ≠ c o i . Ranking loss generalizes Bayes to the multilabel problems, and postulates that there can be some examples for which we cannot provide a single class at a time, even if e.g. any of the classes to which the example belongs are susceptible to appear independently later with the same observation.

Ranking loss Boosting replaces each example ( o, c o ) by a set of 1 ε, × ( c − 1 τ, ) examples, where l ε denotes the Hamming weight of  c o (i.e. the number of classes to which the example belongs). Ea of these new examples is denoted ( o, k, j ), where j and k span all values in {0, 1, …, c - 1} 2 . The distribution of the new examples is renormalized, so that w((o, k, j)) =   w[(o,co)]   whenever co[ j ] = 1 and co[ k ] = 0, and 0 otherwise.

Take some monomial t obtained from the large DC, and all examples satisfying it. We now work with this restricted subset of examples, while calculating the corresponding vector v of t.  Schapire & Singer (1998) propose a cost function which we should minimize in order to minimize the ranking loss. This function is

$$Z=\sum_{o,j,k}w\big{(}\big{(}o,k,j\big{)}\big{)}\,\times e^{-\frac{1}{2}\alpha(\vec{v}^{\prime}|j|-\vec{v}^{\prime}|k|)}\,\,\,.\tag{2}$$

Here, α is a tunable parameter which, intuitively, represents the confidence in the choice of v, and leverages its quality. The better v is at classifying examples, the larger is [ α ]. In our case however, authorizing α ̸= 1 is equivalent to authorizing components for ˆ= in sets
{- x,0, x} for arbitrary x. To really constrain the components of v in {-1,0, +1}, we have chosen to optimize the criterion

$$Z=\sum_{o,j,k}w\big{(}(o,k,j)\big{)}\,\times e^{-\frac{1}{2}(\vec{v}^{\,\prime}|j|-\vec{v}|k\,|)}\tag{3}$$

(therefore forcing α = 1). Schapire & Singer (1998) conjecture that finding the optimal vector minimizing Z in eq. (2) (which is similar to an oblivious hypothesis according to their definitions), or Z given a particular value of α , is NP -Hard when c is not fixed, and when the components of v are in the set {-1,+1}. The following section addresses directly the setting of Schapire & Singer (1998), and presents complexity-theoretic results showing