
| Notation   | Transformation                |
|------------|-------------------------------|
| CD         | polytime conditioning         |
| FO         | polytime forgetting           |
| SFO        | polytime singleton forgetting |
| ∧C         | polytime conjunction          |
| ∧BC        | polytime bounded conjunction  |
| ∨C         | polytime disjunction          |
| ∨BC        | polytime bounded disjunction  |
| ¬C         | polytime negation             |

Table 6: Notations for transformations.

| L       | CD   | FO   | SFO   | ∧C   | ∧BC   | ∨C   | ∨BC   | ¬C   |
|---------|------|------|-------|------|-------|------|-------|------|
| NNF     | √    | ◦    | √     | √    | √     | √    | √     | √    |
| DNNF    | √    | √    | √     | ◦    | ◦     | √    | √     | ◦    |
| d-NNF   | √    | ◦    | √     | √    | √     | √    | √     | √    |
| s-NNF   | √    | ◦    | √     | √    | √     | √    | √     | √    |
| f-NNF   | √    | ◦    | √     | -    | -     | -    | -     | √    |
| d-DNNF  | √    | ◦    | ◦     | ◦    | ◦     | ◦    | ◦     | ?    |
| sd-DNNF | √    | ◦    | ◦     | ◦    | ◦     | ◦    | ◦     | ?    |
| BDD     | √    | ◦    | √     | √    | √     | √    | √     | √    |
| FBDD    | √    | -    | ◦     | -    | ◦     | -    | ◦     | √    |
| OBDD    | √    | -    | √     | -    | ◦     | -    | ◦     | √    |
| OBDD<   | √    | -    | √     | -    | √     | -    | √     | √    |
| DNF     | √    | √    | √     | -    | √     | √    | √     | -    |
| CNF     | √    | ◦    | √     | √    | √     | -    | √     | -    |
| PI      | √    | √    | √     | -    | -     | -    | √     | -    |
| IP      | √    | -    | -     | -    | √     | -    | -     | -    |
| MODS    | √    | √    | √     | -    | √     | -    | -     | -    |

compiling away fluents or actions amounts to forgetting variables. In model-based diagnosis, compiling away every variable except the abnormality ones does not remove any piece of information required to compute the conflicts and the diagnoses of a system (Darwiche, 2001a). Forgetting has also been used to design update operators with valuable properties (Herzig & Rifi, 1999).

Table 6 summarizes the transformations we are interested in and their acronyms. The following proposition states what we know about the tractability of these transformations with respect to the identified target compilation languages.

## Proposition 5.1 **The Results In Table 7 Hold.**

One can draw a number of observations regarding Table 7. First, all languages we **consider satisfy**
CD **and, hence, lend themselves to efficient application of the conditioning transformation. As for**
forgetting multiple variables, only DNNF, DNF, PI and MODS **permit that in polytime. It is important**
to stress here that none of FBDD, OBDD and OBDD< **permits polytime forgetting of multiple variables.**
This is noticeable since some of the recent applications of OBDD< **to planning—within the so-called**
symbolic model checking approach to planning (A. Cimmati & Traverso, 1997)—depend crucially