on the operation of forgetting and it may be more suitable to use a language that satisfies FO in this case. Note, however, that OBDD and OBDD< **allow the forgetting of a single variable in polytime,**
but FBDD **does not allow even that.** d-DNNF **is similar to** FBDD as it satisfies neither FO nor SFO.

It is also interesting to observe that none of the target compilation languages is closed under conjunction. A number of them, however, are closed under bounded conjunction, including OBDD<,
DNF, IP and MODS.

As for disjunction, the only target compilation languages that are closed under disjunction are DNNF and DNF**. The** OBDD< and PI **languages, however, are closed under bounded disjunction. Again,**
the d-DNNF, FBDD and OBDD **languages are closed under neither.**
The only target compilation languages that are closed under negation are FBDD, OBDD and OBDD<,
while it is not known whether d-DNNF or sd-DNNF **are closed under this operation. Note that** d-DNNF and FBDD **support the same set of polytime queries (equivalence checking is unknown for both)**
so they are indistinguishable from that viewpoint. Moreover, the only difference between the two languages in Table 7 is the closure of FBDD **under negation, which does not seem to be that significant** in light of no closure under either conjunction or disjunction. Note, however, that d-DNNF **is more**
succinct than FBDD **as given in Figure 5.**
Finally, OBDD< **is the only target compilation language that is closed under negation, bounded**
conjunction, and bounded disjunction. This closure actually plays an important role **in compiling**
propositional theories into OBDD< **and is the basis of state-of-the-art compilers for this purpose**
(Bryant, 1986).

## 6. Conclusion

The main contribution of this paper is a methodology for analyzing propositional compilation approaches according to two key dimensions: the succinctness of the target compilation language, and the class of queries and transformations it supports in polytime. The second main contribution of the paper is a comprehensive analysis, according to the proposed methodology, of **more than**
a dozen languages for which we have produced a knowledge compilation map, which cross-ranks these languages according to their succinctness, and the polytime queries and transformations they support. This map allows system designers to make informed decisions on which **target compilation**
language to use: after the class of queries/transformations have been decided based on the application of interest, the designer chooses the most succinct target compilation language that supports such operations in polytime. Another key contribution of this paper is the uniform treatment we have applied to diverse target compilation languages, showing how they all are subsets of the NNF
language. Specifically, we have identified a number of simple, yet meaningful, properties, including decomposability, determinism, decision and flatness, and showed how combinations of these properties give rise to different target compilation languages. The studied subsets include **some well known**
languages such as PI**, which has been influential in AI;** OBDD<**, which has been influential in formal**
verification; and CNF and DNF**, which have been quite influential in computer science. The subsets**
also include some relatively new languages such as DNNF and d-DNNF**, which appear to represent**
interesting, new balances between language succinctness and query/transformation tractability.

## Acknowledgments

This is a revised and extended version of the paper "A Perspective on Knowledge Compilation,"
in Proceedings of the 17th **International Joint Conference on Artificial Intelligence (IJCAI'01), pp.**
175-182, 2001. We wish to thank Alvaro del Val, Mark Hopkins, J´erˆome **Lang and the anonymous** reviewers for some suggestions and comments, as well as Ingo Wegener for his help with some of the issues discussed in the paper. This work has been done while the second author was a visiting researcher with the Computer Science Department at UCLA. The first author has been partly