on three key properties of the language: its succinctness, the class of tractable queries it supports, and the class of tractable transformations it admits.

Our goal in this and the following sections is to construct a map on which we place **different**
subsets of the NNF **language according to the above criteria. This map will then serve as a guide to**
system designers in choosing the target compilation language most suitable to their application. It also provides an example paradigm for studying and evaluating further target compilation languages.

We start with a study of succinctness2**in this section (Gogic, Kautz, Papadimitriou, & Selman, 1995).**
Definition 3.1 (Succinctness) Let L1 and L2 **be two subsets of** NNF. L1 **is at least as succinct**
as L2, denoted L1 ≤ L2, iff there exists a polynomial p such that for every sentence α ∈ L2**, there**
exists an equivalent sentence β ∈ L1 where |β| ≤ p(|α|). Here, |α| and |β| are the sizes of α and β, respectively.

We stress here that we do not require that there exists a function that computes β **given** α in polytime; we only require that a polysize β **exists. Yet, our proofs in Appendix A contain specific**
algorithms for computing β from α in certain cases. The relation ≤ **is clearly reflexive and transitive,**
hence, a pre-ordering. One can also define the relation <, where L1 < L2 iff L1 ≤ L2 and L2 6≤ L1.

## Proposition 3.1 **The Results In Table 3 Hold.**

An occurrence of ≤ in the cell of row r and column c **of Table 3 means that the fragment** Lr given at row r is at least as succinct as the fragment Lc given at column c. An occurrence of 6≤ (or 6≤∗) means that Lr is not at least as succinct as Lc **(provided that the polynomial hierarchy does**
not collapse in the case of 6≤∗**). Finally, the presence of a question mark reflects our ignorance about**
whether Lr is at least as succinct as Lc**. Figure 5 summarizes the results of Proposition 3.1 in terms**
of a directed acyclic graph.

A classical result in knowledge compilation states that it is not possible to compile any propositional formula α into a polysize data structure β such that: α and β **entail the same set of clauses,**
and clausal entailment on β **can be decided in time polynomial in its size, unless** NP ⊆ P/poly
(Selman & Kautz, 1996; Cadoli & Donini, 1997). This last assumption implies **the collapse of the**
polynomial hierarchy at the second level (Karp & Lipton, 1980), which is considered very unlikely. We use this classical result from knowledge compilation in some of our proofs of Proposition 3.1, which explains why some of its parts are conditioned on the polynomial hierarchy not collapsing.

We have excluded the subsets BDD, s-NNF, d-NNF and f-NNF **from Table 3 since they do not**
qualify as target compilation languages (see Section 4). We kept NNF and CNF **though given their** importance. Consider Figure 5 which depicts Table 3 graphically. With the exception of NNF and CNF**, all other languages depicted in Figure 5 qualify as target compilation languages. Moreover, with**
the exception of language PI, DNNF **is the most succinct among all target compilation languages—we**
know that PI **is not more succinct than** DNNF**, but we do not know whether** DNNF **is more succinct**
than PI.

In between DNNF and MODS**, there is a succinctness ordering of target compilation languages:**

## Dnnf < D-Dnnf < Fbdd < Obdd < Obdd< < Mods.

DNNF **is obtained by imposing decomposability on** NNF; d-DNNF **by adding determinism;** FBDD by adding decision; and OBDD and OBDD< **by adding ordering (w.r.t. any total ordering on PS in the**
first case and a specific one in the second case). **Adding each of these properties reduces language** succinctness (assuming that the polynomial hierarchy does **not collapse).**
One important fact to stress here is that adding smoothness to d-DNNF **does not affect its succinctness: the** sd-DNNF and d-DNNF **languages are equally succinct. It is also interesting to compare**
2. A more general notion of space efficiency (model preservation for polysize reductions) exists (Cadoli, Donini, Liberatore, & Schaerf, 1996), but we do not need its full generality here.