
## 4.2 Chronological Ordering 4.2.1 The Algorithm

Multidocument summarization of news typically deals with articles published on different dates, and articles themselves cover events occurring over **a wide range of time. Using**
chronological order in the summary to describe the main events helps the user understand what has happened. It seems like a natural and appropriate strategy. As mentioned earlier, in our framework, we are ordering themes; using this strategy, we, therefore, need to assign a date to themes. To identify the date an event occurred requires a detailed interpretation of temporal references in articles. While there have been recent developments in disambiguating temporal expressions and event ordering (Wiebe, **O'Hara, Ohrstrom-Sandgren, &**
McKeever, 1998; Mani & Wilson, 2000; Filatova & Hovy, 2001), **correlating events with the** date on which they occurred is a hard task. In our case, we approximate the theme time by its first publication time; that is, the first time the theme **has been reported in our set** of input articles (see Figure 7). It is an acceptable approximation for news events; the first publication time of an event usually corresponds to its occurrence in real life. For instance, in a terrorist attack story, the theme conveying the attack itself will have a date previous to the date of the theme describing a trial following the attack.

| Theme 5 Oct 5, 11:35am   | Hours after the crash, U.S. officials said that the tragedy had been caused by an S-200 missile fired by Ukraine during military exercises on the Crimean Peninsula.   |
|--------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Oct 6, 6:13am            | U.S. officials said immediately after the crash that they had evidence the passenger jet was hit by a Ukrainian missile.                                               |
| Oct 5, 10:20am           | But U.S. officials said that the crash had been caused by an S-200 missile fired mistakenly by Ukrainian forces during military exercises on the Crimean Peninsula.    |

Figure 7: **A theme with its corresponding sentences. The time theme is shown underlined; it is the**
earliest publication time of the sentences.

Articles released by news agencies are marked with a publication time, consisting of a date and a time with two fields (hour and minutes). Articles from the same news agency are thus guaranteed to have different publication times. This is also quite likely for articles coming from different news agencies. During the development of MultiGen**, we processed**
hundreds of articles, and we never encountered two articles **with the same publication time.** Thus, the publication time serves as a unique identifier over **articles. As a result, when two** themes have the same publication time, it means that they both are reported for the first time in the same article.

Our Chronological Ordering (CO) algorithm takes as input a set of themes and orders them chronologically whenever possible. Each theme is assigned a date corresponding to its first publication. To do so, we select for each theme the sentence that has the earliest publication time. We call it the time stamp sentence and assign its publication time as