
## 5.2 Analysis

The several alternative orderings produced for a single summary exhibit commonalities. We noticed that, within the multiple orderings of a set, some **sentences always appear** together. They do not appear in the same order from one ordering to another, but they share an adjacency relation. From now on, we refer to them as blocks. For each set, we identify blocks by automatically clustering sentences across orderings. We use as a distance metric between two sentences, the average number of sentences that separate them over all orderings. In Figure 10, for instance, the distance between **sentences D and G is 2. The** blocks identified by clustering are: sentences B, D, G and I; sentences A and J; sentences C and F; and sentences E and H.

We observed that all the blocks in the experiment correspond **to clusters of topically**
related sentences. These blocks form units of text dealing with the same subject. In other words, all valid orderings contain blocks of topically related sentences. The notion of grouping topically related sentences is known as cohesion. As defined by Hasan (1984), cohesion is a device for "sticking together" different parts **of the text. Studies show that**
the level of cohesion has a direct impact on reading comprehension (Halliday & Hasan, 1976). Therefore, good orderings are cohesive; this is what **makes the summary readable.**
Conversely, the evaluation of the CO algorithm showed that the summaries that were judged invalid contain abrupt switches of topic. In other words, orderings that are not cohesive are graded poorly. There is a correlation between the quality of the ordering and cohesion.

Incorporating cohesion constraint into our ordering strategy by opportunistically grouping sentences together would be beneficial. Cohesion is achieved by surface devices, such as repetition of words and coreferences. We describe next how we include cohesion in the CO
algorithm based on these surface features.

## 6. The Augmented Algorithm

Disfluencies arise in the output of the CO algorithm when topics are distributed over the whole text, violating cohesion properties (McCoy & Cheng, 1991). A typical scenario is illustrated in Figure 11. The inputs are texts T1, T2, T3 **(ordered by publication time).** A1, A2 and A3 belong to the same theme, whose intersection sentence is A**, and similarly for** B and C. The themes A and B are topically related, but C **is not related. Summary** S1, based only on chronological clues, contains two topical shifts; from A to C **and back from**
C to B. A better summary would be S2, which keeps A and B **together.**

## 6.1 The Algorithm

Our goal is to remove disfluencies from the summary by grouping together topically related themes. The main technical difficulty in incorporating cohesion in our ordering algorithm is to identify and to group topically related themes across multiple documents. In other words, given two themes, we need to determine if they belong to the same cohesion block. For a single document, topical segmentation (Hearst, 1994) could be used to identify blocks, but this technique is not a possibility for identifying cohesion between sentences across multiple documents. Segmentation algorithms typically exploit the **linear structure of an input text;** in our case, we want to group together sentences belonging to **different texts.**