This algorithm ensures that cohesively related themes will **not be spread over the text**
and decreases the number of abrupt switches of topics. Figure 12 shows how the Augmented algorithm improves the sentence order compared with the order in the summary produced by the CO algorithm in Figure 9; sentences quoting US officials **are now grouped together,** and so are the descriptions of the mourning.

| Thousands of people have attended a ceremony in Nairobi commemorating the first anniversary of the deadly bombings attacks against U.S. Embassies in Kenya and Tanzania. Kenyans are observing a national day of mourning in honor of the 215 people who died there. Saudi dissident Osama bin Laden, accused of masterminding the attacks, and nine others are still at large. U.S. federal prosecutors have charged 17 people in the bombings. President Clinton said, "The intended victims of this vicious crime stood for everything that is right about our country and the world". Albright said that the mourning continues.   |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|

Figure 12: A summary produced using the Augmented algorithm. Related sentences are grouped into paragraphs.

## 6.2 Evaluation

Following the same methodology used to evaluate the MO and the CO algorithms, we asked the judges to grade 25 summaries produced by the Augmented algorithm. Results are shown in Figure 13.

The manual effort needed to compare and judge system output is **extensive considering**
that each human judge had to read three summaries for each input set as well as skim the input texts to verify that no misleading information was introduced in the summaries. We collected a corpus of 25 sets of articles for evaluation. Overall, there were 75 summaries to be evaluated. The size of our corpus is comparable with the collection used for the DUC evaluation (30 sets of articles). This evaluation shows a significant improvement in the quality of the orderings from the CO algorithm to the Augmented algorithm. To assess the significance of the improvement, we used the Fisher exact test, conflating Poor and Fair summaries into one category (p-value of 0.04). The augmented algorithm also shows an improvement over the MO algorithm (p-value of 0.07).

| Poor                   | Fair   | Good   |    |
|------------------------|--------|--------|----|
| Majority Ordering      | 3      | 14     | 8  |
| Chronological Ordering | 10     | 8      | 7  |
| Augmented Ordering     | 3      | 8      | 14 |

Figure 13: Evaluation of the the Majority Ordering, the Chronological **Ordering and the Augmented Ordering.**