
## 7. Related Work

Finding an acceptable ordering has not been studied before in domain independent text summarization. In single document summarization, summary **sentences are typically arranged in the same order that they were found in the full document, although Jing (1998)**
reports that human summarizers do sometimes change the original order. In multidocument summarization, the summary consists of fragments of text or **sentences that were selected**
from different texts. Thus, there is no complete ordering of summary sentences that can be found in the original documents.

In domain dependent summarization, it is possible to establish possible orderings a priori**. A valid ordering is traditionally derived from a manual analysis of a corpus of**
texts in the domain, and it typically operates over a set of semantic concepts. A semantic representation of the information is usually available as input to the ordering component.

For instance, in the specific domain of news on the topic of terrorist attacks, summaries can be constructed by first describing the place of the attack, followed by the number of casualties, who the possible perpetrators are, etc.

Another alternative when ordering information, still in the domain dependent framework, is to use a more data driven approach, which produces a more flexible output. A
priori defined simple ordering strategies are combined together by **looking at a set of features from the input. Elhadad and McKeown (2001) use such techniques to produce patient**
specific summaries of technical medical articles. Examples **of features which influence the**
ordering are presence of contradiction or repetition, relevance to the patient characteristics, or type of results being reported. A linear combination of these features assigns a weight to each semantic predicate to be included in the output, allowing them to be ordered. In this case, the features are domain dependent and have been identified through corpus analysis and interviews with physicians. In the case of a domain independent system, it would be an entire new challenge to define and compute such a set of features.

Producing a good ordering of information is also a critical task for the generation community, which has extensively investigated the issue (McKeown, 1985; Moore & Paris, 1993; Hovy, 1993; Bouayad-Agha, Power, & Scott, 2000; Mooney, Carberry, & McCoy, 1990). One approach is top-down, using schemas (McKeown, 1985) or plans (Dale, 1992) to determine the organizational structure of the text. This approach postulates a rhetorical structure which can be used to select information from an underlying knowledge base. Because the domain is limited, an encoding can be developed of the kinds of propositional content that match rhetorical elements of the schema or plan, thereby allowing content to be selected and ordered. Rhetorical Structure Theory (RST) allows for more flexibility in ordering content by establishing relations between pairs of propositions. Constraints based on intention
(e.g., Moore & Paris, 1993), plan-like conventions (e.g., Hovy, 1993), or stylistic constraints (e.g., Bouayad-Agha et al., 2000) are used as preconditions **on the plan operators containing** RST relations to determine when a relation is used and how it is ordered with respect to other relations. Another approach (Mooney et al., 1990) is bottom-up and is used to group together stretches of text in a long, generated document by finding propositions that are related by a common focus. Since this approach was developed **for a generation system, it** finds related propositions by comparisons of proposition arguments at the semantic level.