In our case, we are dealing with a surface representation, so **we find alternative methods**
for grouping text fragments.

A more recent approach by Duboue and McKeown (2001) has been implemented to automatically estimate constraints on information ordering in the medical domain, at the content planning stage. Using a collection of semantically **tagged transcripts written by** domain experts, Duboue and McKeown (2001) identify basic adjacency patterns contained within a plan, as well as their ordering. MultiGen **generates summaries of news on any**
topic. In such an unconstrained domain, it would be impossible to enumerate the semantics for all possible types of sentences which could match the elements of a schema, a plan or rhetorical relations. For instance, Duboue and McKeown build their content planner based on a set of 29 semantic categories; in our case, there is no such regularity in the input information. Furthermore, it would be difficult to specify a generic rhetorical plan for a summary of news. Instead, content determination in MultiGen **is opportunistic, depending**
on the kinds of similarities that happen to exist between a set of news documents. Similarly, we describe here an ordering scheme that is opportunistic and bottom-up, depending on the cohesion and temporal connections that happen to exist between selected text.

Our ordering component takes place after the content selection of the information in a pipeline architecture, in contrast to generation systems, where usually the ordering and the content selection come in tandem. This separation might **come at a cost - if there is**
no good ordering to the given extracted information, it is not possible to go back to the content selection to extract new information. In summarization, content selection is driven by salience criteria. We believe that the same ordering strategy should work with different content selectors, independently of their salience criteria. Therefore, we choose to keep the two components, selection and ordering, as two separate modules.

## 8. Conclusion And Future Work

In this paper we investigated information ordering constraints in multidocument summarization in the news genre. We evaluated two alternative ordering strategies, Chronological Ordering (CO) and Majority Ordering (MO). Our experiments show that MO performs well only when all input texts follow similar organization of the **information. In the domains**
where this constraint holds, MO would be an appropriate and highly effective strategy. But in the news genre we cannot make this assumption; thus it is not an appropriate solution.

The Chronological Ordering (CO) algorithm can provide an acceptable solution for many cases, but is not sufficient when summaries contain information that is not event based. Our experiments, using a corpus that we collected of multiple alternative summaries each of multiple documents, show that cohesion is an important constraint contributing to ordering. Moreover, they also show that appropriate ordering of information is critical to allow for easy comprehension of the summary and that it is not the case that all possible orderings of information are acceptable. We developed an operational algorithm that integrates cohesion as part of the CO algorithm, and implemented it as part of the MultiGen **summarization**
system. Our evaluation of the system shows significant improvement in summary quality.

While in this paper we focused on augmenting the CO algorithm, we believe that MO
is a promising strategy and should not be neglected. It is clear that different forms of summarization are useful in different situations, depending on the intended purpose of