targeted for the news genre. The first question we addressed is the importance of ordering. We conducted experiments which show that ordering significantly affects the reader's comprehension of a text. Our experiments also show that although there is no single ideal ordering of information, ordering is not an unconstrained problem; the number of good orderings for a given text is limited. The second question addressed was the analysis and use of data to infer a strategy for ordering. Existing corpus based methods, such as supervised learning, are not easily applicable to our problem in part because of lack of training data. Given that there are multiple possible orderings, a corpus providing one ordering for each set of information does not allow us to differentiate between sentences which must be together and sentences which happen to be together. This led us **to develop a corpus of data**
sets, each of which contains multiple acceptable orderings **of a single text. Such a corpus** is expensive to construct and therefore, does not provide enough data for pure statistical approaches. Instead, we used a hybrid corpus analysis strategy that first automatically identifies commonalities across orderings. Manual analysis of the resulting clusters led to the identification of constraints on ordering. Finally, we evaluated plausible ordering strategies by asking humans to judge the results.

Our set of experiments together suggests an ordering algorithm that integrates constraints from an approximation of the temporal sequence of the underlying events and relatedness between content elements. Our evaluation of plausible strategies measured the usefulness of a Chronological Ordering algorithm used in previous summarization systems
(McKeown et al., 1999; Lin & Hovy, 2001) as well as an alternative, original strategy, Majority Ordering. Our evaluation showed that the two ordering algorithms alone do not yield satisfactory results. The first, Majority Ordering, is critically linked to the level of similarity of information ordering across the input texts. **When input texts have different** orderings, however, the algorithm produces unpredictable **and unacceptable results. The** second, Chronological Ordering produces good results when **the information is event-based,** and therefore, is temporally sequenced. When texts do not refer to events, but describe states or properties, this algorithm falls short.

Our automatic analysis revealed that topical relatedness is an important constraint; groups of related sentences tend to appear together. Our algorithm combines Chronological Ordering with constraints from topical relatedness. Evaluation shows that the augmented algorithm significantly outperforms either of the simpler methods alone. This strategy can be characterized as bottom-up since final ordering of the text emerges from how the data groups together, whether by related content or by chronological sequence. This contrasts with top-down strategies such as RST (Moore & Paris, 1993; Hovy, 1993), schemas (McKeown, 1985) or plans (Dale, 1992) which impose an external, rhetorically motivated ordering on the data.

In the following sections, we first show that the way information is ordered in a summary can critically affect its overall quality. We then give an overview of our summarization system, MultiGen**. We next describe the two naive ordering algorithms and evaluate**
them, followed by a study of multiple orderings produced by humans. This allows us to determine how to improve the Chronological Ordering algorithm using cohesion as an additional constraint. The last section describes the augmented algorithm along with its evaluation.