
## 2. Impact Of Ordering On The Overall Quality Of A Summary

Even though the problem of ordering information for multidocument summarization has received relatively little attention, we hypothesize that **good ordering is crucial to produce** summaries of quality. The consensus architecture of the state of the art summarizers consists of a content selection module in which the salient information is extracted and a regeneration module in which the information is reformulated into a fluent **text. Ideally, the regeneration** component contains devices that perform surface repairs on **the text by doing anaphora** resolution, introducing cohesion markers or choosing the appropriate lexical paraphrases. Our claim in this paper is that the multidocument summarization architecture needs an explicit ordering component. If two pieces of information extracted by the content selection phase end up together but should not, in fact, be next one to another, surface devices will not repair the impaired flow of information in the summary. An **ordering strategy would**
help avoid this situation.

It is clear that ordering cannot improve the output of earlier stages of a summarizer, among them content selection1**; however, finding an acceptable ordering can enhance user**
comprehension of the summary and, therefore, its overall quality. Of course, surface devices are still needed to smooth the output summary, but this is out **of the scope of this paper (but** see (Schiffman, Nenkova, & McKeown, 2002)). In this section we show that the quality of ordering has a direct effect on user comprehension of the summary. To verify our hypothesis, we performed an experiment, measuring the impact of ordering on the user's comprehension of summaries.

We selected ten summaries produced by the Columbia Summarization system (McKeown, Barzilay, Evans, Hatzivassiloglou, Kan, Schiffman, & Teufel, 2001). It is composed of a router and two underlying summarizers - MultiGen and DEMS **(Difference Engine**
for Multidocument Summarization). Depending on the type of **input articles to be summarized, the router selects the appropriate summarizer. We evaluated this system through the**
Document Understanding Conference 2001 (DUC)2**evaluation, where summaries produced**
by several systems were graded by human judges according to different criteria, among them how well the information contained in the summary is ordered. To actually identify a possible impact of ordering on comprehension, we selected only summaries where humans judged the ordering as poor.3 **For each summary, we manually reordered the sentences**
generated by the summarizer, using the input articles as a reference. When doing so, we did not change the content - all the sentences in the reordered summaries were the same ones as in the originally produced summaries. This process yields ten additional reordered summaries and thus, overall our collection contains twenty **summaries.**
Two subjects other than the authors participated in this experiment. Each summary was read by one participant without having access to the input articles. We distributed the summaries among the judges so that none of them read both an original summary and its reordering. They were asked to grade how well the summary could be understood, using the ratings "Incomprehensible," "Somewhat comprehensible" or "Comprehensible".