for ordering sentences suitable for multidocument summarization in the news genre. The first algorithm, Majority Ordering (MO), relies only on the original orders of sentences in the input documents. The second one, Chronological Ordering (CO), uses time-related features to order sentences. This strategy was originally implemented in MultiGen and followed by other summarization systems (Radev, Jing, & Budzikowska, 2000; Lin & Hovy, 2001). In the MultiGen **framework, ordering sentences is equivalent to ordering themes,**
and we describe the algorithms in terms of themes. This makes **sense because, ultimately,** the summary will be composed of a sequence of sentences, each **one constructed from the** information in one theme. Our evaluation shows that these methods alone do not provide an adequate strategy for ordering.

## 4.1 Majority Ordering 4.1.1 The Algorithm

In single document summarization, the order of sentences in **the output summary is typically** determined by their order in the input text. This strategy can be adapted to multidocument summarization. Consider two themes, Th1 and Th2; if sentences from Th1 **precede sentences**
from Th2 in all input texts, then presenting Th1 before Th2 **is likely to be an acceptable** order. To use the majority ordering algorithm when the order **between sentences from** Th1 and Th2 **varies from one text to another, we must augment the strategy. One way to define**
the order between Th1 and Th2 **is to adopt the order occurring in the majority of the**
texts where Th1 and Th2 **occur. This strategy defines a pairwise order between themes.**
However, this pairwise relation is not necessarily transitive. For example, given the themes Th1, Th2 and Th3 and the following situation: Th1 precedes Th2 in a text, Th2 **precedes**
Th3 in the same text or in another text, and Th3 precedes Th1 **in yet another text; there is a**
conflict between the orders (Th1,Th2,Th3) and (Th3,Th1**). Since transitivity is a necessary**
condition for a relation to be called an order, this relation **does not form an order.**
We, therefore, have to expand this pairwise relation to provide a total order. In other words, we have to find a linear ordering between themes which maximizes the agreement between the orderings provided by the input texts. For each pair of themes, Thi and Thj ,
we keep two counts, Ci,j and Cj,i; Ci,j **is the number of input texts in which sentences from**
Thi occur before sentences from Thj , and Cj,i **is the same for the opposite order. The weight**
of a linear order (Thi1

,... ,Thik

) is defined as the sum of the counts for every pair Cil
,im, such that il ≤ im and l,m ∈ {1 ... k}**. Stating this problem in terms of a directed graph**
where nodes are themes, and a vertex from Thi to Thj has the weight Ci,j **, we are looking**
for a path with maximal weight which traverses each node exactly once (see Figure 3). We call such a graph a precedence graph.

The problem of finding a path with maximal weight has been addressed by Cohen, Schapire, and Singer (1999) in the task of learning orderings. They adopt a two-stage approach. In the first stage, given a training corpus of ordered instances and a set of features describing them, a binary preference function is learned. In the second stage, new instances are ordered so that agreement with the learned preference function is maximized. To do so, Cohen et al. (1999) represent the preference function as a directed, weighted graph. Our precedence graph can be seen as such a graph where the preference function