ultimate destination) to get its instantaneous load. We write that load as:

$$z_{r}(t)\equiv\sum_{d}x_{r,d}(t),$$

where the index d runs over ultimate destinations, and xr d ( t ) is the total traffic at time t going from r towards d. After its instantaneous load at time t is evaluated, the router sends all its traffic to the next downstream routers, in a manner governed by the underlying routing algorithm. We indicate such "next routers" by writing:

$$x_{r,d}(t)=\sum_{r^{\dag}}x_{r,d,r^{\dag}}(t),$$

where r' is the next router for traffic ( r, d ), i.e., the first stop on the path to be followed from router r to ultimate destination d. After all such routed traffic goes to those next downstream routers, the cycle repeats itself, until all traffic reaches its destinations.

In our simulations, for simplicity, traffic was only introduced into the system (at the source routers) at the beginning of successive disjoint waves of L consecutive time steps each 6 . We use κ ( t ) to indicate either the integer-valued wave number associated with time t or the set of all times in that wave, as the context indicates.

In a real network, the cost of traversing a router depends on "after-effects" of recent instantaneous loads, as well as the current instantaneous load. To simulate this effect, we use time-averaged values of the load at a router rather than instantaneous load to determine the cost a packet incurs in traversing that router.  More formally, we define the router's windowed load, Z,(t), as the running average of that router's load value over a window of the previous W timesteps ( W is always set to an integer multiple of L ):
where the value of Xr,d(t) is set by

$$Z_{r}(t)\equiv\frac{1}{W}\sum_{t^{\prime}=t-W+1}^{t}z_{r}(t^{\prime})=\sum_{d}X_{r,d}(t),$$
$$X_{r,d}(t)=\frac{1}{W}\sum_{t^{\prime}=t-W+1}^{t}x_{r,d}(t^{\prime})).$$

Intuitively, for large enough W , using such a window to determine costs across routers means that typically those costs will only change substantially over time scales significantly larger than that of the individual routing decisions. Formally, the windowed load is the argument to a load-to-cost function, V( ), which provides the cost accrued at time t by each packet traversing the router at this timestep. That is, at time t, the cost for each packet to traverse router r is given by V(Zr(t)) 7 . Note that in our model, the costs are accrued at the routers, not the links. Also note that for simplicity we do not physically instantiate the cost as a temporal delay in crossing a router. Different routers have different