(RL) Kaelbing, Littman, & Moore, 1996; Sutton & Barto, 1998; Sutton, 1988; Watkins &
Dayan, 1992) to try to maximize their utilities.

The field of Collective Intelligence (COIN) is concerned with the central design problem for collectives  (Wolpert, Tumer, & Frank, 1999; Wolpert & Tumer, 1999):  How, without any detailed modeling of the overall system, can one set utility functions for the individual agents in a COIN so that the overall dynamics reliably and robustly achieves large values of the provided world utility? In other words, how can we leverage an assumption that our learners are individually fairly good at what they do, to have the collective as a whole perform well? 1 An example of where this question looms very large is the problem of how to optimize the flow of certain entities (e.g., information packets, cars) from sources to destinations across a network of routing nodes. Here we are concerned with the version of the problem in which "optimization" consists of minimizing aggregate cost incurred by the entities flowing to their destinations, and where an agent controls the routing decisions of each node in the network. This problem underlies the distributed control of a large array of real-world domains, including internet routing, voice/video communication, traffic flows, etc.  From the COIN perspective, the problem reduces to the question of what goals one ought to provide to ea router's agent so that ea agent's self-interestedly pursuing its own utility results in maximal throughput of the entire system ("incentive engineering" ).

In this paper we investigate the application of recently developed COIN techniques, to this routing domain. Like all work concerning COINs, these techniques are designed to be very broadly applicable, and in particular are not designed for the routing domain.

Accordingly, their performance in this domain serves as a good preliminary indication of their more general usefulness.

To ground the discussion, we will concentrate on the telecommunications data routing problem where the entities being routed are packets.  Currently, many real-world algorithms for this problem are based on the Shortest Path Algorithm (SPA). In this algorithm each routing node in the network is controlled by an agent who maintains a "routing table" of the
"shortest paths" (i.e., sequences of links having minimal total incurred costs) from its node to each of the possible destination nodes in the net.  Then at each moment the agent satisfies any routing requests for a particular destination node by sending all its packets down the associated shortest path. Many Ideal SPA (ISPA) algorithms exist for efficiently computing the shortest path when agent-to-agent path-cost communication is available and the costs for traversing each agent's node are unvarying in time, e.g., Dijkstra's Algorithm (Ahuja, Magnanti, & Orlin, 1993; Bertsekas & Gallager, 1992; Deo & Pang, 1984; Dijkstra, 1959).

If a non-infinitesimal amount of traffic is to be routed to a particular destination at some moment by some agent, then that agent's sending all that traffic down a single path will not result in minimal cost, no matter how that single path is chosen. However if it must choose a single path for all its traffic, and if the routing decisions by all other agents are fixed, then tautologically by using the ISPA the agent chooses the best such path, as far as the traffic it is routing is concerned. Accordingly, in the limit of routing an infinitesimally