

![0_image_0.png](0_image_0.png)

## 6. Conclusion

Effective routing in a network is a fundamental problem in many fields, including data communications and transportation. Using a shortest path algorithm (SPA) on each of the routers to determine that router's decisions is a popular approach to this problem. However under certain circumstances it suffers from a number of undesirable effects.  One such effect is Braess' paradox, where for the same pattern of introduced traffic into a network, increasing the capacity of that network results in lower overall throughput, due to the harmful sideeffects of the decisions made by each router on the traffic in the rest of the system. Even the theoretical load-balancing algorithm, which addresses some of these effects to produce decisions that are optimal for any single moment of time, can still suffer from side-effects that result in sub-optimal performance. This is because such effects extend across time
(i.e., what you do now affects performance later) as well as space.

The Collective Intelligence approach is a novel way of controlling distributed systems so as to avoid deleterious side-effects of routing decisions. The central idea is to have learning algorithms control the autonomous agents that constitute the overall distributed system.

In such a Collective Intelligence (COIN), the central issue is to determine the personal objectives to be assigned to each of those autonomous agents. One wants to choose those goals so that the greedy pursuit of those goals by the associated learning algorithms leads to desirable behavior of the overall system.  In this paper we have summarized the mathematics of designing such goals and derived a routing algorithm based on that mathematics.

We ran computer simulations to compare a COIN-based algorithm with an ideal SPA
(whose performance upper-bounds all real-world SPA's) for routing. The COIN-based algorithm was severely handicapped. The estimation of the "effect sets" used by that algorithm was exceedingly crude. In addition, the learning algorithms of the agents were particularly unsophisticated, and therefore were not able to effectively maximize their individual performances. In contrast, the ideal SPA had access to more information concerning the state of the system than the (real-world-implementable) COIN did, information that no real-world SPA could access.