small amount of traffic, with all other agents' strategies being a "background", the ISPA is the optimal (least aggregate incurred cost) routing strategy for the traffic of the associated single agent considered individually.

One might hope that more generally, if the agent must allot all of its traffic to a single path and all other agents' traffic decisions are fixed, then its oosing that path via the ISPA would be the choice that minimizes total incurred cost of all traffic across the net, at least in the limit of infinitesimally little traffic. This is not the case though, because in using the SPA the agent is not concerned with the deleterious side-effects of its actions on the costs to the traffic routed by other agents (Korilis, Lazar, & Orda, 1997a; Wolpert et al.,
199). The problem is made all the worse if the other agents are allowed to change their decisions in response to our agent's decision. In the extreme case, as elaborated below, if all agents were to try to minimize their personal costs via ISPA's, then the agents would actually all receive higher cost than would be the case under an alternative set of strategies. This is an instance of the famous Tragedy Of the Commons (TOC) (Hardin, 1968).

Deleterious side-effects need not be restricted to extend over space; they can also extend over time. Indeed, consider the algorithm of having all agents at a given moment make routing decisions that optimize global cost incurred by the traffic currently being routed, an algorithm often called "load-balancing" (LB) (Heusse, Snyers, Guerin, & Kuntz, 1998). By definition, LB avoids the deleterious side-effects over space that can result in the TOC
for the costs incurred by the traffic currently being routed. However, due to side-effects over time, even conventional LB can be suboptimal as far as global cost averaged across time is concerned. Intuitively, one would have to use "load-balancing over time" to ensure truly optimal performance. So even if one could somehow construct a distributed protocol governing the the agents that caused them to implement LB, still one would not have gotten theme to all act in a perfectly coordinated fashion. Such difficulties make this an appropriate domain in which to investigate how well COIN techniques work in practice.

Real-world SPA's (RSPA) work by applying an ISPA to the estimated costs for traversing each path of every agent. Typically those estimates will be in error because agent-to-agent communication is not instantaneous, and therefore routing tables may be based on out of date information. More generally though, even if that communication were instantaneous, the cost to traverse an agent's node may be different by the time the packet arrives at that node. Accordingly, in general the performance of RSPA's is bounded above by that of the associated ISPA. In this paper we do not wish to investigate such topics, but rather to highlight the issue of side-effects. Accordingly we "rig the game" in our experimental comparisons in favor of the SPA, by using ISPA's rather than RSPA's.

In general, even without side-effects, determining the optimal solution to a flow problem
(e.g., determining what the loads on each link need to be to maximize throughput on a non-cooperative data network) can be nontractable (Ahuja et al., 1993; Orda, Rom, & Sidi, 1993b). Therefore, we will concern ourselves with providing good solutions that avoid the difficulties the ISPA has with side-effects. It is not our aim here to present algorithms that find the best possible (perfectly load-balanced over time) solution. Previous work on using machine learning to improve routing has sometimes resulted in better performance than (non-idealized) SPA's (Littman & Boyan, 1993; Boyan & Littman, 1994; Stone, 2000; Marbach, Mihatsch, Schulte, & Tsisiklis, 1998).  That work has not grappled with the central COIN design problem however.