In Section 2 we discuss SPA's deficiencies and in particular their manifestations in Braess' paradox. Then, in Section 3 we present the theory of collective intelligence, an approach that promises to overcome those deficiencies. We then discuss the routing model we will use in our experiments, and show how the theory of COINs can be applied to that model to provide an alternative to shortest path algorithms in Section 3. In Section 5 we present simulation results with that model comparing ISPA to COINs.  These results demonstrate that in networks running ISPA, the per packet costs can be as much as 32
% higher than in networks running algorithms based on COIN theory. In particular, even though it only has access to imprecise estimates of costs (a handicap that does not hold for ISPA), the COIN-based algorithm almost always avoids Braess' paradox, in stark contrast to the ISPA. In that the cost incurred with ISPA's is presumably a lower bound on that of an SPA not privy to instantaneous communication, the implication is that COINs can outperform such real-world SPA's.  We conclude that the techniques of the field of collective intelligence can be highly effective in designing the utility functions of the members of a MAS
to ensure they work in a coordinated and efficient manner to optimize overall performance.

## 2. Suboptimality Of Shortest Path Routing And Braess Paradox

In this section we first demonstrate the suboptimality of an SPA when we have multiple agents making simultaneous routing decisions, where no agent knows ahead of time the other's choice, and therefore does not know ahead of time exactly what the costs will be.

We then demonstrate that such suboptimality can hold even when only one agent is making a decision, and it knows what decisions the others have previously made. Next we present Braess' paradox, a particularly pointed instance of these effects (for other discussion of Braess' paradox in SPA routing, see Bass, 1992; Cohen & Kelly, 1990; Cohen & Jeffries, 1997; Hogg, 1995; Glance & Hogg, 1995; Korilis, Lazar, & Orda, 1999).

## 2.1  Suboptimality Of Spa

Perhaps the simplest example of how individual greed on the part of all agents can lead to their collective detriment occurs when two agents determine that their shortest path is through a shared link with a limited capacity, while both have a second option that is slightly less preferable. In such a case, their using the common link degrades the performance of both parties, since due to limited capacity the performance of that link will quickly fall below that of their second option.

More precisely, consider the case where the shared link has a cost given by x 3 when traversed by x packets, and where each router has an optional second link to the destination where the cost for traffic x to traverse such a second link is 2 x . Acting alone, with a single packet to send, they would both send that packet through the shared link (cost of 1).

However by both doing so, they incur a larger cost (cost of 8) than if they had both used their second choices (cost of 4). Without knowing what each other will do ahead of time
(information not conventionally contained in routing tables), the agents will necessarily have mistaken cost estimates and therefore make incorrect routing decisions. In this, even in the limit of differentially small packets, use of SPA will lead to a wrong routing decision.