
## 2.2  Suboptimality Of Ispa

We now analyze a situation where the routers may know what the loads are but are each acting to optimize the delays experienced by their packets alone.  Consider the network shown in Figure 1. Two source routers X and Y each send one packet at a time, with X sending to either intermediate router A or B, and Y sending to either B or C. This type of network may arise in many different topologies as a subnetwork. Accordingly, difficulties associated with this network can also apply to many more complex topologies.

![0_image_0.png](0_image_0.png)

Let xA, xB, yB, and yC, be the packet quantities at a particular fixed time t, at A, B,
or C , and originating from X or Y , as indicated. At t , each source has one packet to send.

So each of our variables is binary, with xA + xB = yB + yC = 1. Have Vi(zi) be the cost, per packet, at the single instant t, at router i, when the total number of packets at that instant on that router is zi. So the total cost incurred by all packets at the time t, G ( , , , ), equals xaVa(xa) + (xb+yb)Vb(xb+yb) + (yc)Vc(yc)
In an ISPA, X chooses which of xA or xB = 1 so as to minimize the cost incurred by X's packet alone, gx(x) ≡ xAVA(xA) + xBVB(xB+yB). In doing this the ISPA ignores the ybVb(xb + yb) term, i.e., it ignores the "side effects" of X's decision. Real-world SPA's typically try to approximate this by having X choose either A or B according to whether VA (0) or VB(yB) is smaller, where those two values can be estimated via pings, for example.

The right thing to do from the point of view of minimizing the global cost of course is instead to have X minimize G( , , ), or more precisely, the components of G( , , ) that depend on X . Writing it out for this case, X ought to act to minimize XAVA ( XA ) + ( XB +
YB)VB(xB+yB). Due to the constraint that xA + xB = 1, this means sending down A iff VA(1) < (YB + 1)VB(YB + 1) - YBVB(YB), which differs from the ISPA result in that X is concerned with the full cost of going through router B, not just the portion of that cost that its packet receives.

In the context of this example, this G -minimizing algorithm constitutes "load-balancing"
(LB). Note that so long as sgn[VA(0) - VB(YB) - VBVk(YB)] \# sgn[VA(0) - VB(YB)], even in the limit of infinitesimally small traffic (so that xA + xB equals some infinitesimal δ),
ISPA and LB still disagree. LB considers side-effects of current routing decisions on other traffic currently being routed. However because it does not consider side-effects of routing decisions on future traffic, even LB may not optimize global cost averaged across all time,