posteriori **bound as part of the policy iteration procedure. More details are provided in**
Section 7.

One could rewrite the bound in Theorem 3.5 in terms of the worst case projection error βP **, or the worst projection error in a cycle of policies, if approximate policy iteration**
gets stuck in a cycle. These formulations would be closer to the analysis of Bertsekas and Tsitsiklis (1996, Proposition 6.2, p.276). However, consider the case where most policies (or most policies in the final cycle) have a low projection error, but there are a few policies that cannot be approximated well using the projection operation, so that they have a large one-step projection error. A worst-case bound would be very **loose, because it would be** dictated by the error of the most difficult policy to approximate. On the other hand, using our discounted accumulated error formulation, errors introduced by policies that are hard to approximate decay very rapidly. Thus, the error bound represents an "average" case analysis: a decaying average of the projection errors for policies encountered at the successive iterations of the algorithm. As in the convergent case, **this bound can be computed**
easily as part of the policy iteration procedure when max-norm projection is used.

The practical benefit of a posteriori **bounds is that they can give meaningful feedback on**
the impact of the choice of the value function approximation **architecture. While we are not**
explicitly addressing the difficult and general problem of feature selection in this paper, our error bounds motivate algorithms that aim to minimize the error given **an approximation**
architecture and provide feedback that could be useful in future efforts to automatically discover or improve approximation architectures.

## 3.3 Approximate Linear Programming 3.3.1 The Exact Algorithm

Linear programming provides an alternative method for solving MDPs. It formulates the problem of finding a value function as a linear program (LP). Here the LP variables are V1, . . . , VN , where Vi represents V(xi): the value of starting at the i**th state of the system.**
The LP is given by:

$$\begin{array}{l l}{{\mathrm{Variables:}}}&{{V_{1},\ldots,V_{N}\ ;}}\\ {{\mathrm{Minimize:}}}&{{\sum_{{\bf x}_{i}}\alpha({\bf x}_{i})\ V_{i}\ ;}}\\ {{\mathrm{Subject~to:}}}&{{V_{i}\geq\left[R({\bf x}_{i},a)+\gamma\sum_{j}P({\bf x}_{j}\mid{\bf x}_{i},a)V_{j}\right]\quad\forall{\bf x}_{i}\in{\bf X},a\in A,}}\end{array}$$
$$\quad(7)$$

where the state relevance weights α **are positive. Note that, in this exact case, the solution**
obtained is the same for any positive weight vector. It is interesting to note that steps of the simplex algorithm correspond to policy changes at single states, while steps of policy iteration can involve policy changes at multiple states. In **practice, policy iteration tends** to be faster than the linear programming approach (Puterman, 1994).

## 3.3.2 Approximate Linear Program

The approximate formulation for the LP approach, first proposed by Schweitzer and Seidmann (1985), restricts the space of allowable value functions to the linear space spanned by our basis functions. In this approximate formulation, the variables are w1, . . . , wk**: the**
weights for our basis functions. The LP is given by: