FactoredLP (C, b,O)
// C = {c1**, . . . , c**k} *is the set of basis functions.*
// b = {b1**, . . . , b**m} is the set of target functions.

//O *stores the elimination order.*
//Return a (polynomial) set of constraints Ω *equivalent to* φ ≥Pi wici(x) + Pj bj (x), ∀x .

//Data structure for the constraints in factored LP.

Let Ω = {} .

//Data structure for the intermediate functions generated *in variable elimination.*
Let F = {} .

//Generate equality constraint to abstract away basis functions.

For each ci ∈ C:
Let Z **= Scope[**ci].

For each assignment z ∈ Z, create a new LP variable u fi z and add a constraint to Ω:
u fi z = wici(z).

Store new function fi to use in variable elimination step: F = **F ∪ {**fi}.

//Generate equality constraint to abstract away target functions.

For each bj ∈ b:
Let Z **= Scope[**bj].

For each assignment z ∈ Z, create a new LP variable u fj z and add a constraint to Ω:
u fj z = bj(z).

Store new function fj to use in variable elimination step: F = **F ∪ {**fj}.

//Now, P
F *contains all of the functions involved in the LP, our constraints become:* φ ≥
ei∈F ei(x), ∀x , which we represent compactly using a variable elimination *procedure.*
For i = 1 to number of variables:
//Select the next variable to be eliminated.

Let l = O(i) ;
//Select the relevant functions.

Let e1**, . . . , e**L be the functions in F whose scope contains Xl, and let Zj **= Scope[**ej ].

//Introduce linear constraints for the maximum over current variable Xl.

Define a new function e with scope Z = ∪
L
j=1Zj − {Xl} to represent maxxl PL
j=1 ej .

Add constraints to Ω to enforce maximum: for each assignment z ∈ Z:
u ez ≥
X
L
j=1 u ej
(z,xl)[Zj ]∀xl.

//Update set of functions.

Update the set of functions F = F ∪ {e} \ {e1**, . . . , e**L}.

//Now, all variables have been eliminated and all functions *have empty scope.*
Add last constraint to Ω:
φ ≥
X
ei∈F
ei.

Return Ω.

Figure 5: Factored LP algorithm for the compact representation of the exponential set of constraints φ ≥Pi wici(x) + Pj bj (x), ∀x.