Recall that our value function estimates have the linear form Hw**. As we described in**
Section 4.1, the greedy policy for this type of value function is given by:

## Greedy(Hw)(X**) = Arg Max** Aqa(X),

where each Qa can be represented by: Qa(x) = R(x, a) + Pi wi g a i
(x).

If we attempt to represent this policy naively, we are again faced with the problem of exponentially large state spaces. Fortunately, as shown **by Koller and Parr (2000), the** greedy policy relative to a factored value function has the form of a decision list**. More**
precisely, the policy can be written in the form ht1, a1i,ht2, a2i, . . . ,htL, aLi**, where each** ti is an assignment of values to some small subset Ti of variables, and each ai**is an action.**
The greedy action to take in state x is the action aj **corresponding to the first event** tj in the list with which x **is consistent. For completeness, we now review the construction of**
this decision-list policy.

The critical assumption that allows us to represent the policy as a compact decision list is the default action assumption described in Section 6.1. Under this assumption, the Qa functions can be written as:

$$Q_{a}({\bf x})=R^{a}({\bf x})+\sum_{i=1}^{r}R_{i}({\bf x})+\sum_{i}w_{i}\ g_{i}^{a}({\bf x}),$$
$\mathbf{f}=\mathbf{a}\mathbf{b}\mathbf{a}+\mathbf{b}\mathbf{a}\mathbf{b}$ 6. 
where Ra has scope restricted to Ua. The Q function for the default action d **is just:**
Qd(x) = Pr i=1 Ri(x) + Pi wi g d i
(x).

We now have a set of linear Q-functions which implicitly describes a policy π**. It is**
not immediately obvious that these Q **functions result in a compactly expressible policy.**
An important insight is that most of the components in the weighted combination are identical, so that g a i**is equal to** g d ifor most i**. Intuitively, a component** g a i**corresponding**
to the backprojection of basis function hi(Ci) is only different if the action a **influences**
one of the variables in Ci. More formally, assume that Effects[a] ∩ Ci = ∅**. In this case,** all of the variables in Ci have the same transition model in τa and τd**. Thus, we have**
that g a i
(x) = g d i
(x); in other words, the ith component of the Qa **function is irrelevant**
when deciding whether action a is better than the default action d**. We can define which**
components are actually relevant: let Ia be the set of indices i such that **Effects**[a]∩Ci 6= ∅.

These are the indices of those basis functions whose backprojection differs in Pa and Pd.

In our example DBN of Figure 2, actions and basis functions involve single variables, so Iai = i.

Let us now consider the impact of taking action a over the default action d**. We can**
define the impact - the difference in value - as:

$$\delta_{a}({\bf x})=Q_{a}({\bf x})-Q_{d}({\bf x});\tag{19}$$ $$=R^{a}({\bf x})+\sum_{i\in I_{a}}w_{i}\ \left[g_{i}^{a}({\bf x})-g_{i}^{d}({\bf x})\right].$$

This analysis shows that δa(x**) is a function whose scope is restricted to**

$$\mathbf{T}_{a}=\mathbf{U}^{a}\cup\left[\cup_{i\in I_{a}}\Gamma_{a}(\mathbf{C}_{i}^{\prime})\right].$$
. **(20)**
$$(20)$$
