FactoredAPI (P, R, γ, H, O, ε, tmax)
//P is the factored transition model.

//R *is the set of factored reward functions.* //γ is the discount factor.

//H *is the set of basis functions* H = {h1**, . . . , h**k}.

//O stores the elimination order.

//ε *Bellman error precision.*
//tmax maximum number of iterations.

//Return the basis function weights w computed by approximate policy iteration.

//Initialize weights Let w(0) = 0.

//Cache the backprojections of the basis functions.

For each basis function hi ∈ H; for each action a:
Let g a i = **Backproj**a (hi).

//Main approximate policy iteration loop.

Let t = 0.

Repeat
//**Policy improvement part of the loop.**
//Compute decision list policy for iteration t *weights.*
Let ∆(t) = DecisionListPolicy(Ra + γPi w
(t)
ig a i
).

//**Value determination part of the loop.**
//Initialize constraints for max-norm projection LP.

Let Ω
+ = {} and Ω
− = {}.

//Initialize indicators.

Let I = {}.

//For every branch of the decision list policy, generate the relevant set of constraints, and update the indicators to constraint the state space for future branches.

For each branch htj , aj i in the decision list policy ∆(t):
//Instantiate the variables in Tj *to the assignment given in* tj .

Instantiate the set of functions {h1 − γg aj 1
, . . . , hk − γg aj k
} with the partial state assignment tj and store in C.

Instantiate the target functions Raj with the partial state assignment tj and store in b.

Instantiate the indicator functions I with the partial state assignment tj and store in I
′.

//Generate the factored LP constraints for the current decision list branch.

Let Ω
+ = Ω+ ∪ FactoredLP(C, −b + I
′, O).

Let Ω
− = Ω− ∪ FactoredLP(−C, b + I
′, O).

//Update the indicator functions.

Let Ij (x) = −∞1(x = tj ) and update the indicators I = **I ∪ I**j .

//We can now obtain the new set of weights by solving an LP, which corresponds to the max-norm projection.

Let w(t+1) be the solution of the linear program: minimize φ, subject to the constraints {Ω
+, Ω
−}.

Let t = t + 1.

Until BellmanErr(Hw(t)) ≤ ε or t ≥ tmax or w(t−1) = w(t).

Return w(t).

Figure 9: Factored approximate policy iteration with max-norm projection algorithm.