{X1, . . . , Xn}−Ti**, and computes the maximum only over the states consistent with** Ti = ti.

To guarantee the second condition, we ensure that we do not impose any constraints on states associated with previous decisions. This is achieved by adding indicators Ij **for each** previous decision tj , with weight −∞. More specifically, Ij **is a function that takes value**
−∞ for states consistent with tj and zero for other all assignments of Tj **. The constraints**
for the i**th branch will be of the form:**

$$\phi\geq R({\bf x},a_{i})+\sum_{l}w_{l}\left(\gamma g_{l}({\bf x},a_{i})-h({\bf x})\right)+\sum_{j<i}-\infty{\bf1}({\bf x}={\bf t}_{j}),\qquad\quad\forall{\bf x}\sim[{\bf t}_{i}],\tag{21}$$

where x ∼ [ti] defines the assignments of X consistent with ti**. The introduction of these**
indicators causes the constraints associated with ti **to be trivially satisfied by states in** Sj for j < i. Note that each of these indicators is a restricted-scope function of Tj **and can**
be handled in the same fashion as all other terms in the factored LP. Thus, for a decision list of size L, our factored LP contains constraints from 2L **cost networks. The complete**
approximate policy iteration with max-norm projection algorithm is outlined in Figure 9.

## 6.4 Comparisons

It is instructive to compare our max-norm policy iteration algorithm to the L2**-projection**
policy iteration algorithm of Koller and Parr (2000) in terms of computational costs per iteration and implementation complexity. Computing the L2 **projection requires (among**
other things) a series of dot product operations between basis functions and backprojected basis functions hhi •g π j i. These expressions are easy to compute if Pπ **refers to the transition**
model of a particular action a. However, if the policy π **is represented as a decision list, as is**
the result of the policy improvement step, then this step becomes much more complicated.

In particular, for every branch of the decision list, for every pair of basis functions i and j, and for each assignment to the variables in Scope[hi] ∪ **Scope[**g a j
], it requires the solution of a counting problem which is ♯P**-complete in general. Although Koller and Parr show that**
this computation can be performed using a Bayesian network (BN) inference, the algorithm still requires a BN inference for each one of those assignments at each branch of the decision list. This makes the algorithm very difficult to implement efficiently in practice.

The max-norm projection, on the other hand, relies on solving a linear program at every iteration. The size of the linear program depends on the cost **networks generated. As we** discuss, two cost networks are needed for each point in the decision list. The complexity of each of these cost networks is approximately the same as only one of the BN inferences in the counting problem for the L2 **projection. Overall, for each branch in the decision**
list, we have a total of two of these "inferences," as opposed **to one for each assignment of**
Scope[hi] ∪ **Scope[**g a j
] for every pair of basis functions i and j**. Thus, the max-norm policy**
iteration algorithm is substantially less complex computationally than the approach based on L2**-projection. Furthermore, the use of linear programming allows us to rely on existing**
LP packages (such as CPLEX), which are very highly optimized.

It is also interesting to compare the approximate policy iteration algorithm to the approximate linear programming algorithm we presented in Section 5. In the approximate linear programming algorithm, we never need to compute the decision list policy. The policy is always represented implicitly by the Qa **functions. Thus, this algorithm does not**