This paper is a greatly expanded version of work that was published before in Guestrin et al. (2001a), and some of the work presented in Guestrin et al. **(2001b, 2002).**

## 2. Factored Markov Decision Processes

A Markov decision process (MDP) is a mathematical framework **for sequential decision** problems in stochastic domains. It thus provides an underlying semantics for the task of planning under uncertainty. We begin with a concise overview of the MDP framework, and then describe the representation of **factored MDPs**.

## 2.1 Markov Decision Processes

We briefly review the MDP framework, referring the reader to the books by Bertsekas and Tsitsiklis (1996) or Puterman (1994) for a more in-depth review. A **Markov Decision Process**
(MDP) is defined as a 4-tuple (X, A, R, P) where: X is a finite set of |X| = N **states;** A is a finite set of actions; R is a reward function R : X × A 7→ R, such that R(x, a**) represents**
the reward obtained by the agent in state x after taking action a; and P is a **Markovian** transition model **where** P(x
′| x, a) represents the probability of going from state x **to state**
x
′ with action a. We assume that the rewards are bounded, that is, there exists Rmax **such**
that Rmax ≥ |R(x, a)| , ∀x, a.

Example 2.1 **Consider the problem of optimizing the behavior of a system administrator**
(SysAdmin) maintaining a network of m **computers. In this network, each machine is**
connected to some subset of the other machines. Various possible network topologies can be defined in this manner (see Figure 1 for some examples). In one **simple network, we might**
connect the machines in a ring, with machine i connected to machines i + 1 and i − 1**. (In**
this example, we assume addition and subtraction are performed modulo m.)
Each machine is associated with a binary random variable Xi**, representing whether it**
is working or has failed. At every time step, the SysAdmin receives a certain amount of money (reward) for each working machine. The job of the SysAdmin is to decide which machine to reboot; thus, there are m+ 1 **possible actions at each time step: reboot one of the**
m **machines or do nothing (only one machine can be rebooted per time step). If a machine**
is rebooted, it will be working with high probability at the next time step. Every machine has a small probability of failing at each time step. However, if a neighboring machine fails, this probability increases dramatically. These failure probabilities define the transition model P(x
′| x, a), where x **is a particular assignment describing which machines are working or**
have failed in the current time step, a **is the SysAdmin's choice of machine to reboot and** x
′
is the resulting state in the next time step.

We assume that the MDP has an infinite horizon and that future rewards are discounted exponentially with a discount factor γ ∈ [0, 1). A stationary policy π **for an MDP is a** mapping π : X 7→ A, where π(x) is the action the agent takes at state x**. In the computer**
network problem, for each possible configuration of working **and failing machines, the policy** would tell the SysAdmin which machine to reboot. Each policy is associated with a **value**
function Vπ ∈ RN , where Vπ(x**) is the discounted cumulative value that the agent gets if**
it starts at state x and follows policy π. More precisely, the value Vπ of a state x **under**