Definition 8.4 A value rule ρ = hc : vi is a function ρ : X 7→ R such that ρ(x) = v **when**
x is consistent with c and 0 **otherwise.**
Note that a value rule hc : vi **has a scope** C.

It is important to note that value rules are not required to be **mutually exclusive and**
exhaustive. Each value rule represents a (weighted) indicator function, which takes on a value v in states consistent with some context c**, and 0 in all other states. In any given state,**
the values of the zero or more rules consistent with that state are simply added together.

Example 8.5 **In our construction example, we might have a set of rules:**
ρ1 = hPlumbing **= done : 100**i; ρ2 = hElectricity **= done : 100**i; ρ3 = hPainting **= done : 100**i; ρ4 = hAction **= plumb :** −10i;
...

which, when summed together, define the reward function R = ρ1 + ρ2 + ρ3 + ρ4 + **· · ·**.

In general, our reward function Rais represented as a **rule-based function**:
Definition 8.6 A rule-based function f : X 7→ R is composed of a set of rules {ρ1**, . . . , ρ**n}
such that f(x) = Pn i=1 ρi(x).

In the same manner, each one of our basis functions hj **is now represented as a rule-based**
function.

This notion of a rule-based function is related to the tree-structure functions used by Boutilier et al. **(2000), but is substantially more general. In the tree-structure value functions, the rules corresponding to the different leaves are mutually exclusive and exhaustive.**
Thus, the total number of different values represented in the **tree is equal to the number** of leaves (or rules). In the rule-based function representation, the rules are not mutually exclusive, and their values are added to form the overall function value for different settings of the variables. Different rules are added in different settings, and, in fact, with k **rules,**
one can easily generate 2k **different possible values, as is demonstrated in Section 9. Thus,**
the rule-based functions can provide a compact representation for a much richer class of value functions.

Using this rule-based representation, we can exploit both CSI and additive independence in the representation of our factored MDP and basis functions. We now show how the basic operations in Section 4 can be adapted to exploit our rule-based representation.

## 8.2 Adding, Multiplying And Maximizing Consistent Rules

In our table-based algorithms, we relied on standard sum and **product operators applied to** tables. In order to exploit CSI using a rule-based representation, we must redefine these standard operations. In particular, the algorithms will need to add or multiply rules that ascribe values to overlapping sets of states.

We will start by defining these operations for rules with the same context: