the algorithm, we initially need to add a set of value rules with 0 value, which guarantee that our rule function f is complete (i.e.**, there is at least one rule consistent with every**
context).

The correctness of this procedure follows directly from the **correctness of the rule-based**
variable elimination procedure described by Zhang and Poole, merely by replacing summations with product with max, and products with products with **sums. We conclude this**
section with a small example to illustrate the algorithm:
Example 8.13 Suppose we are maximizing a **for the following set of rules:**
ρ1 = h¬a : 1i, ρ2 = ha ∧ ¬b : 2i, ρ3 = ha ∧ b ∧ ¬c : 3i, ρ4 = h¬a ∧ b : 1i.

When we add completing rules, we get:
ρ5 = h¬a : 0i, ρ6 = ha : 0i.

In the first part of the algorithm, we need to add consistent rules: We add ρ5 to ρ1 **(which**
remains unchanged), combine ρ1 with ρ4, ρ6 with ρ2, and then the split of ρ6 **on the context**
of ρ3**, to get the following inconsistent set of rules:**
ρ2 = ha ∧ ¬b : 2i, ρ3 = ha ∧ b ∧ ¬c : 3i, ρ7 = h¬a ∧ b : 2i, (from adding ρ4 *to the consistent rule from* **Split**(ρ1 6 b))
ρ8 = h¬a ∧ ¬b : 1i, *(from* **Split**(ρ1 6 b))
ρ9 = ha ∧ b ∧ c : 0i, *(from* **Split**(ρ6 6 a ∧ b ∧ ¬c)).

Note that several rules with value 0 **are also generated, but not shown here because they are**
added to other rules with consistent contexts. We can move to **the second stage (repeat loop)**
of MaxOut. We remove ρ2, and ρ8, and maximize a **out of them, to give:**
ρ10 = h¬b : 2i.

We then select rules ρ3 and ρ7 and split ρ7 on c (ρ3 **is split on the empty set and is not**
changed),
ρ11 = h¬a ∧ b ∧ c : 2i, ρ12 = h¬a ∧ b ∧ ¬c : 2i.

Maximizing out a from rules ρ12 and ρ3**, we get:**
ρ13 = hb ∧ ¬c : 3i.

We are left with ρ11, which maximized over its counterpart ρ9 **gives**
ρ12 = hb ∧ ¬c : 2i.

Notice that, throughout this maximization, we have not split on the variable C **when** ¬b ∈ ci, giving us only 6 distinct rules in the final result. This is not **possible in a table-based**
representation, since our functions would then be over the 3 variables a,b,c**, and therefore**
must have 8 entries.