
## 8.5 Rule-Based Factored Lp

In Section 4.2.2, we showed that the LPs used in our algorithms have exponentially many constraints of the form: φ ≥Pi wi ci(x) − b(x), ∀x**, which can be substituted by a single,**
equivalent, non-linear constraint: φ ≥ maxx Pi wi ci(x)−b(x**). We then showed that, using**
variable elimination, we can represent this non-linear constraint by an equivalent set of linear constraints in a construction we called the factored **LP. The number of constraints in** the factored LP is linear in the size of the largest table generated in the variable elimination procedure. This table-based algorithm can only exploit additive independence. We now extend the algorithm in Section 4.2.2 to exploit both **additive and context-specific structure,**
by using the rule-based variable elimination described in the previous section.

Suppose we wish to enforce the more general constraint 0 ≥ maxy F
w(y**), where** F
w(y) =
Pj f w j
(y) such that each fj is a rule. As in the table-based version, the superscript w **means**
that fj might depend on w. Specifically, if fj comes from basis function hi**, it is multiplied**
by the weight wi; if fj **is a rule from the reward function, it is not.**
In our rule-based factored linear program, we generate LP variables associated with contexts; we call these LP rules. An LP rule has the form hc : ui**; it is associated with a** context c and a variable u **in the linear program. We begin by transforming all our original** rules f w jinto LP rules as follows: If rule fj has the form hcj : vj i **and comes from basis**
function hi, we introduce an LP rule ej = hcj : uj i **and the equality constraint** uj = wivj .

If fj **has the same form but comes from a reward function, we introduce an LP rule of the** same form, but the equality constraint becomes uj = vj .

Now, we have only LP rules and need to represent the constraint: 0 ≥ maxy Pj ej (y).

To represent such a constraint, we follow an algorithm very similar to the variable elimination procedure in Section 8.4. The main difference occurs in the MaxOut (f, B**) operation in**
Figure 13. Instead of generating new value rules, we generate new LP rules, with associated new variables and new constraints. The simplest case occurs **when computing a split or**
adding two LP rules. For example, when we add two value rules in the original algorithm, we instead perform the following operation on their associated LP rules: If the LP rules are hc : uii and hc : uj i, we replace these by a new rule hc : uki**, associated with a new LP**
variable uk with context c, whose value should be ui + uj **. To enforce this value constraint,**
we simply add an additional constraint to the LP: uk = ui + uj **. A similar procedure can**
be followed when computing the split.

More interesting constraints are generated when we perform **a maximization. In the**
rule-based variable elimination algorithm in Figure 13, this maximization occurs when we replace a set of rules:
hc ∧ B = bi: vii, ∀bi ∈ **Dom(**B),

by a new rule  $$\left\langle\mathbf{c}:\max_{i}v_{i}\right\rangle.$$  Following the same process as in the LP rule summation above, if we are maximizing 
$$e_{i}=\langle\mathbf{c}\wedge B=b_{i}:u_{i}\rangle,\forall b_{i}\in\mathrm{Dom}(B),$$
we generate a new LP variable uk associated with the rule ek = hc : uki**. However, we** cannot add the nonlinear constraint uk = maxi ui**, but we can add a set of equivalent linear**