"Star" topology, the factors generated by variable elimination are small. Thus, although the running times are polynomial in the number of state variables for both methods, the tablebased representation is significantly faster than the rule-based one, due to the overhead of managing the rules. The "Ring" topology illustrates an intermediate behavior: "single+" basis functions induce relatively small variable elimination factors, thus the table-based approach is faster. However, with "pair" basis the factors are larger and the rule-based approach starts to demonstrate faster running times in larger problems. Finally, the "Reverse star" topology represents the worst-case scenario for the table-based approach. Here, the scope of the backprojection of a basis function for the central machine will involve all computers in the network, as all machines can potentially influence the central one in the next time step. Thus, the size of the factors in the table-based variable elimination approach are exponential in the number of machines in the network, which is illustrated by the exponential growth in Figure 17(c). The rule-based approach can exploit the CSI in this problem; for example, the status of the central machine Status0 **only depends on machine**
j if the value selector is j, i.e., if Selector0 = j**. By exploiting CSI, we can solve the same**
problem in polynomial time in the number of state variables, **as seen in the second curve in** Figure 17(c).

It is also instructive to compare the portion of the total running time spent in CPLEX
for the table-based as compared to the rule-based approach. **Figure 18 illustrates this**
comparison. Note that amount of time spent in CPLEX is significantly higher for the table-based approach. There are two reasons for this difference: first, due to CSI, the LPs generated by the rule-based approach are smaller than the table-based ones; second, rulebased variable elimination is more complex than the table-based one, due to the overhead introduced by rule management. Interestingly, the proportion of CPLEX time increases as the problem size increases, indicating that the asymptotic **complexity of the LP solution is**
higher than that of variable elimination, thus suggesting that, for larger problems, additional large-scale LP optimization procedures, such as constraint generation, may be helpful.

## 9.3 Comparison To Apricodd

The most closely related work to ours is a line of research that began with the work of Boutilier et al. (1995). In particular, the approximate Apricodd algorithm **of Hoey** et al. **(1999), which uses analytic decision diagrams (ADDs) to represent the value function**
is a strong alternative approach for solving factored MDPs. **As discussed in detail in Section 10, the Apricodd algorithm can successfully exploit context-specific structure in the**
value function**, by representing it with the set of mutually-exclusive and exhaustive branches**
of the ADD. On the other hand, our approach can exploit both additive and context-specific structure in the problem, by using a linear combination of non-mutually-exclusive rules. To better understand this difference, we evaluated both our rule-based approximate linear programming algorithm and Apricodd in two problems, Linear and Expon**, designed by** Boutilier et al. **(2000) to illustrate respectively the best-case and the worst-case behavior**
of their algorithm. In these experiments, we used the web-distributed version of Apricodd (Hoey, St-Aubin, Hu, & Boutilier, 2002), running it locally on a Linux Pentium III
700MHz with 1GB of RAM.