vectors. In a more compact notation, our approximate value function is then represented by Hw.

The expressive power of this linear representation is equivalent, for example, to that of a single layer neural network with features corresponding to the basis functions defining H. Once the features are defined, we must optimize the coefficients w **in order to obtain a**
good approximation for the true value function. We can view this approach as separating the problem of defining a reasonable space of features and the induced space H**, from the**
problem of searching within the space. The former problem is **typically the purview of**
domain experts, while the latter is the focus of analysis and **algorithmic design. Clearly,**
feature selection is an important issue for essentially all **areas of learning and approximation.** We offer some simple methods for selecting good features for MDPs in Section 11, but it is not our goal to address this large and important topic in this **paper.**
Once we have a chosen a linear value function representation **and a set of basis functions,**
the problem becomes one of finding values for the weights w such that Hw **will yield**
a good approximation of the true value function. In this paper, we consider two such approaches: approximate dynamic programming using policy **iteration and approximate**
linear programming. In this section, we present these two approaches. In Section 4, we show how we can exploit problem structure to transform these **approaches into practical** algorithms that can deal with exponentially large state spaces.

## 3.2 Policy Iteration 3.2.1 The Exact Algorithm

The exact policy iteration algorithm iterates over policies, producing an improved policy at each iteration. Starting with some initial policy π
(0)**, each iteration consists of two phases.**
Value determination **computes, for a policy** π
(t), the value function Vπ(t) **, by finding the**
fixed point of the equation Tπ(t)Vπ(t) = Vπ(t) **, that is, the unique solution to the set of linear**
equations:

$${\mathcal{V}}_{\pi^{(t)}}({\bf x})=R({\bf x},\pi^{(t)}({\bf x}))+\gamma\sum_{{\bf x}^{\prime}}P({\bf x}^{\prime}\mid{\bf x},\pi^{(t)}({\bf x})){\mathcal{V}}_{\pi^{(t)}}({\bf x}^{\prime}),\forall{\bf x}.$$

The policy improvement **step defines the next policy as**

$$\pi^{(t+1)}={\mathrm{Greedy}}({\mathcal{V}}_{\pi^{(t)}}).$$

It can be shown that this process converges to the optimal policy (Bertsekas & Tsitsiklis, 1996). Furthermore, in practice, the convergence to the optimal policy is often very quick.

## 3.2.2 Approximate Policy Iteration

The steps in the policy iteration algorithm require a manipulation of both value functions and policies, both of which often cannot be represented explicitly in large MDPs. To define a version of the policy iteration algorithm that uses approximate value functions, we use the following basic idea: We restrict the algorithm to using **only value functions within the** provided H; whenever the algorithm takes a step that results in a value function V **that is** outside this space, we project **the result back into the space by finding the value function**
within the space which is closest to V**. More precisely:**