# A Linear Time Natural Evolution Strategy For Non-Separable Functions

Yi Sun, Faustino Gomez, Tom Schaul, and J¨urgen Schmidhuber IDSIA, University of Lugano & SUPSI, Galleria 2, Manno, CH-6928, Switzerland {yi,tino,tom,juergen}@idsia.ch Abstract. We present a novel Natural Evolution Strategy (NES) variant, the Rank-One NES (R1-NES), which uses a low rank approximation of the search distribution covariance matrix. The algorithm allows computation of the natural gradient with cost linear in the dimensionality of the parameter space, and excels in solving high-dimensional nonseparable problems, including the best result to date on the Rosenbrock function (512 dimensions).

## 1 Introduction

Black-box optimization (also called zero-order optimization) methods have received a great deal of attention in recent years due to their broad applicability to real world problems [7,9–11,15,18]. When the structure of the objective function is unknown or too complex to model directly, or when gradient information is unavailable or unreliable, such methods are often seen as the last resort because all they require is that the objective function can be evaluated at specific points.

In continuous black-box optimization problems, the state-of-the-art algorithms, such as xNES [4] and CMA-ES [8], are all based the same principle [1,4]:
a Gaussian search distribution is repeatedly updated based on the objective function values of sampled points. Usually the full covariance matrix of the distribution is updated, allowing the algorithm to adapt the size and shape of the Gaussian to the local characteristics of the objective function. Full parameterization also provides invariance under affine transformations of the coordinate system, so that ill-shaped, highly non-separable problems can be tackled. However, this generality comes with a price. The number of parameters scales quadratically in the number of dimensions, and the computational cost per sample is at least quadratic in the number of dimensions [13], and sometimes cubic [4, 16].

This cost is often justified since evaluating the objective function can dominate the computation, and thus the main focus is on the improvement of sampling efficiency. However, there are many problems, such as optimizing weights in neural networks where the dimensionality of the parameter space can be very large (e.g. many thousands of weights), the quadratic cost of updating the search distribution can become the computational bottleneck. One possible remedy is to restrict the covariance matrix to be diagonal [14], which reduces the computation per function evaluation to O(d), linear in the number d of dimensions.