with parameter set θ = h*σ, u*i. The special part of the parameterization is the vector u ∈ R
d, which corresponds to the predominant direction of C. This allows the search distribution to be aligned in any direction by adjusting u, enabling the algorithm to follow valleys not aligned with the current coordinate axes, which is essential for solving non-separable problems.

Since σ should always be positive, following the same procedure in [4], we parameterize σ = e λ, so that λ ∈ R can be adjusted freely using gradient descent without worrying about σ becoming negative. The parameter set is adjusted to θ = h*λ, u*i accordingly.

From the derivation of [16], the natural gradient on the sample mean is given by O˜µ log p (x|θ) = x − µ. (2)
In the subsequent discussion we always assume µ = 0 for simplicity. It is straightforward to sample from N (0, C)
1 by lettting y ∼ N (0, I), z ∼ N (0, 1), then x = σ (y + zu) ∼ N (0, C) .

The inverse of C can also be computed easily as

The inverse of $\sigma$ can also be computed easily as  $$C^{-}=\sigma^{-2}\left(I-\frac{1}{1+r^{2}}uu^{\top}\right),$$  where $r^{2}=u^{\top}u.$ Using the relation $\det\left(I+uu^{\top}\right)=1+u^{\top}u,$ the determinant of $C$ is 
$$\begin{array}{c}{{|C|=\sigma^{2d}\left(1+r^{2}\right).}}\\ {{\mathrm{ab}\,|\,C|=1.}}\end{array}$$
Knowing $C^{-}$ and $|C|$ allows the log-likelihood to be written explicitly as:  $$\log p\left(x|\theta\right)=const-\frac{1}{2}\log|C|-\frac{1}{2}x^{\top}C^{-}x$$ $$=const-\lambda d-\frac{1}{2}\log\left(1+r^{2}\right)-\frac{1}{2}e^{-2\lambda}x^{\top}x+\frac{1}{2}\frac{e^{-2\lambda}}{1+r^{2}}\left(x^{\top}u\right)^{2}.$$  The regular gradient with respect to $\lambda$ and $u$ can then be computed as:
$$\nabla_{\lambda}\log p\left(x|\theta\right)=-d+e^{-2\lambda}\left(x^{\top}x-\frac{\left(x^{\top}u\right)^{2}}{1+r^{2}}\right),\tag{3}$$ $$\nabla_{u}\log p\left(x|\theta\right)=-\frac{u}{1+r^{2}}+e^{-2\lambda}\left[-\frac{\left(x^{\top}u\right)^{2}u}{\left(1+r^{2}\right)^{2}}+\frac{\left(x^{\top}u\right)x}{1+r^{2}}\right].\tag{4}$$
Replacing x with e λ(y + zu), then the Fisher can be computed by marginalizing out i.i.d. standard Gaussian variables y and z, namely,

$$\begin{array}{r l}{F=E_{x}\left[\,\!\!{\bigtriangledown}_{\theta}\log p\left(x|\theta\right)\,\!\!{\bigtriangledown}_{\theta}\log p\left(x|\theta\right)^{\top}\,\!\!\right]}\\ {}&{{}}\\ {=E_{y,z}\left[\,\!\!{\bigtriangledown}_{\theta}\log p\left(y+z u|\theta\right)\,\!\!{\bigtriangledown}_{\theta}\log p\left(y+z u|\theta\right)^{\top}\,\!\!\right].}\end{array}$$

1 For succinctness, we always assume the mean of the search distribution is 0. This can be achieved easily by shifting the coordinates.