whose inverse is given by

$$C_{2}^{-}=I+\frac{2+d\left(r^{2}-1\right)}{2\left(d-1\right)}v v^{\top}.$$

Combining the results gives the analytical solution of the inverse Fisher:

$$F^{-}=\frac{1+r^{2}}{2r^{2}\left(d-1\right)}\left[\begin{array}{l l}{{\frac{r^{2}}{1+r^{2}}}}&{{-r v^{\top}}}\\ {{-r v\,\,\,2\left(d-1\right)}}&{{I+\left[2+d\left(r^{2}-1\right)\right]v v^{\top}}}\end{array}\right].$$

Multiplying F
− with the regular gradient in Eq.3 and Eq.4 gives the natural gradient for λ and u:

$$\tilde{\nabla}_{\lambda}\log p\left(x|\theta\right)=\frac{1}{2\left(d-1\right)}\left[\left(e^{-2\lambda}x^{\top}x-d\right)-\left(e^{-2\lambda}\left(x^{\top}v\right)^{2}-1\right)\right].\tag{5}$$

and

$$\tilde{\triangledown}_{u}\log p\left(x|\theta\right)=\frac{e^{-2\lambda}}{2\left(d-1\right)r}\left[\left(1-d\right)\left(x^{\top}v\right)^{2}+\left(r^{2}+1\right)\left(\left(x^{\top}v\right)^{2}-x^{\top}x\right)\right].\tag{6}$$

Note that computing both O˜λ log p (x|θ) and O˜u log p (x|θ) requires only the inner products x
>x and x
>v, therefore can be done O (d) storage and time.

## 3.1 Reparameterization

The natural gradient above is obtained with respect to u. However, direct gradient update on u has an unpleasant property when O˜u log p (x|θ) is in the opposite direction of u, which is illustrated in Fig. 2(a). In this case, the gradient tends to shrink u. However, if O˜u log p (x|θ) is large, adding the gradient will flip the direction of u, and the length of u might even grow. This causes numerical problems, especially when r is small. A remedy is to separate the length and direction of u, namely, reparameterize u = e cv, where kvk = 1 and e cis the length of u.

Then the gradient update on c will never flip u, and thus avoid the problem.

Note that for small change δu, the update on c and v can be obtained from

$$\begin{array}{l}{\delta c={\frac{1}{2}}\log\left(u+\delta u\right)^{\top}\left(u+\delta u\right)-c}\\ {\quad\quad\simeq{\frac{1}{2}}\log\left(u^{\top}u+2\delta u^{\top}u\right)-c}\\ {\quad\quad={\frac{1}{2}}\log u^{\top}u+{\frac{1}{2}}\log\left(1+{\frac{2\delta u^{\top}u}{u^{\top}u}}\right)-c}\\ {\quad\quad\simeq{\frac{\delta u^{\top}u}{u^{\top}u}}}\end{array}$$
