# From Causal Models To Counterfactual Structures∗

Joseph Y. Halpern†
Computer Science Department Cornell University halpern@cs.cornell.edu October 16, 2018

## Abstract

Galles and Pearl [1998] claimed that "for recursive models, the causal model framework does not add any restrictions to counterfactuals, beyond those imposed by Lewis's [possible-worlds] framework." This claim is examined carefully, with the goal of clarifying the exact relationship between causal models and Lewis's framework. Recursive models are shown to correspond precisely to a subclass of (possible-world) counterfactual structures. On the other hand, a slight generalization of recursive models, models where all equations have unique solutions, is shown to be incomparable in expressive power to counterfactual structures, despite the fact that the Galles and Pearl arguments should apply to them as well. The problem with the Galles and Pearl argument is identified: an axiom that they viewed as irrelevant, because it involved disjunction (which was not in their language),
is not irrelevant at all.

## 1 Introduction

Counterfactual reasoning arises in broad array of fields, from statistics to economics to law. Not surprisingly, there has been a great deal of work on giving semantics to counterfactuals. Perhaps the best-known approach is due to Lewis [1973] and Stalnaker [1968], and involves possible worlds. The idea is that a counterfactual of the form "if A were the case then B would be the case", typically written A  B, is true at a world w if B is true at all the worlds closest to w where A is true. Of course, making this precise requires having some notion of "closeness" among worlds.

More recently, Pearl [2000] proposed the use of causal models based on *structural equations* for reasoning about causality. In causal models, we can examine the effect of *interventions*, and answer questions of the form "if random variable X were set to x, what would the value of random variable Y be". This suggests that causal models can also provide semantics for (at least some) counterfactuals.

The relationship between the semantics of counterfactuals in causal models and in counterfactual structures (i.e., possible-worlds structures where the semantics of counterfactuals is given in terms of
∗A preliminary version of this paper appears in the Proceedings of the Twelfth International Conference on Principles of Knowledge Representation and Reasoning (KR 2010), 2010.

†Supported in part by NSF grants IIS-0534064, IIS-0812045, and IIS-0911036, and by AFOSR grants FA9550-08-1-0438 and FA9550-09-1-0266, and ARO grant W911NF-09-1-0281.

arXiv:1106.2647v2 [cs.AI] 17 Aug 2013