
## 3 Relating Causal Models To Counterfactual Structures

As the title suggests, in this section I take a closer look at the relationship between causal models and counterfactual structures. On the surface, the two approaches are quite different. Consider the causal model for the forest fire example, discussed in Section 2.1. If we want to capture the forest fire using counterfactual structures, perhaps the most natural way to do it is to have worlds in the counterfactual structure that correspond to the eight possible settings of the three exogenous variables (MD, L, and FF). We can take primitive propositions that correspond to the settings of these variables as well; that is, the primitive propositions have the form MD = i, L = i, and FF = i, for i = 0, 1. The actual world w is the one where MD = 1∧L = 1∧FF = 1 holds. The closest world relation is described in the obvious way by the equations. For example, if we consider the conjunctive model, where FF = min(MD, L),
so that both the match and the lightning are required to start the fire, then the closest world to w where MD = 0 is the one where MD = 0 ∧ L = 1 ∧ FF = 0 holds. On the other hand, in the disjunctive model, where FF = max(MD, L), the closest world to w where MD = 0 holds is the one where MD = 0 ∧ L = 1 ∧ FF = 1 holds. There is a sense in which the causal model and the corresponding counterfactual structure(s) constructed this way satisfy the same formulas. In this section, I make this intuition precise. More generally, I show that to every causal model in Trec, there is a corresponding counterfactual structure that satisfies the same formulas; however, this is not the case for every causal model in Tuniq.

Given a signature S = (U, V, R), consider the set ΦS of primitive propositions of the form X = x for X ∈ V and x ∈ R(x). We restrict to counterfactual structures M = (Ω**, R, π**) for this set of primitive propositions, where π is such that, for each world w ∈ Ω and variable X ∈ V, exactly one of the formulas X = x is true. Call such structures *acceptable*. In an acceptable counterfactual structure, a world can be associated with an assignment of values to the random variables. An acceptable structure
(Ω**, R, π**) is *full* if, for each assignment v of values to variables and all w ∈ Ω, there is a world in Ωw where v is the assignment. (I discuss the consequences of fullness shortly.) Let Ma(ΦS) consist of all acceptable counterfactual structures over S; let Mf (ΦS) consist of all full acceptable counterfactual structures over S; let M+
a(ΦS) = Ma(ΦS) ∩ M+(ΦS); and let M+
f
(ΦS) = Mf (ΦS) ∩ M+(ΦS).

As before, I identify [Y~ = ~y](X = x) ∈ Luniq(S) with the formula Y~ = ~y  (X = x) ∈ LC
1
(ΦS).

I abuse notation and use Luniq(S) to denote the sublanguage of L
C
1
(ΦS)that arises via this identification.

The following is easy to show.

Proposition 3.1 C3 and C4 are valid in Ma(ΦS)*; C2 is valid in* M+
a
(ΦS)*; C1 is valid in* Mf (ϕS).

Notice that, in Ma(ΦS) (and hence all of its subsets), the following two formula schemes are valid:
V1. ∨x∈R(X)X = x V2. If x 6= x
′, then X = x ⇒ X 6= x
′.

In Mf (ΦS), the following axiom is valid:
V3. ¬[X~ = ~x]**false**.