
## 4 Discussion

I have shown that the expressive power of causal models as models for counterfactuals is incomparable to that of the Lewis-Stalnaker "closest-world" possible-worlds semantics for counterfactuals; thus, the definition of counterfactuals in causal models is not, in general, compatible with the axioms of possible world semantics, although it is if we restrict to recursive causal models.

Specifically, causal models where the equations are recursive can be viewed as defining a strict subclass of the standard possible-worlds semantics. More precisely, a set of structural equation defines a world w (characterized by the unique solution to the equations) and can be implicitly viewed as defining an ordering relation on worlds such that, for every formula X~ = ~x, the solution to the equations when X~ is set to ~x determines a world wX~ =~x that is the world closest to w according to the ordering such that X~ = ~x. Somewhat surprisingly, this is not the case if we go to the larger class of causal models defined by equations that are not recursive, but have a unique solution for all settings X~ = ~x. Of course, it is still the case that there is a world wX~ =~x determined by the equations when X~ is set to ~x. However, there is, in general, no ordering on worlds such that wX~ =~x is the closest world to w according to the ordering.

A closeness ordering on worlds places some restrictions (e.g., those characterized by the formula ¬ϕ in Theorem 3.7) that do not hold in all causal models in Tuniq.

So where does this leave us? It is still the case that, in causal models, a formula such as ϕ  ψ is true at a world w if ψ is true at some appropriate world w
′satisfying ϕ. However, w
′cannot be viewed as the "closest" world to w satisfying ϕ. This leaves open the question of whether there are other ways of defining "appropriateness" other than "closeness". I do not have strong intuitions here, but it is a question that is perhaps worth pursuing. My own feeling is that these arguments show that models in Tuniq − Trec are actually not good models for causality. It is quite difficult to verify that a nonrecursive causal model is in Tuniq, as the model T given in Theorem 3.7 satisfying ϕ shows. I am not aware of any interesting real-world situation that is captured by a model in Tuniq − Trec. Further evidence of the
"unreasonableness" of models in Tuniq − Trec is given by recent work of Zhang, Lam, and de Clerq
[2012]. They show that although the reversibility axiom blocks cycles of counterfactual dependence of length two, it does not block longer cycles. Indeed, they observe that the causal model T of Theorem 3.7 has a cycle of length three.

Does this mean that we should restrict to recursive models? There are certainly equations in physics
(e.g., those connecting pressure and volume) that exhibit circular dependencies. Perhaps nonrecursive models would be appropriate for them (although once we add time to the picture, we may well be able to use a recursive model to capture any particular scenario). In a general nonrecursive model, there may be several solutions to an intervention (see [Halpern and Pearl 2005, Appendix A.4] for further discussion of this point). But this just corresponds to there being several worlds satisfying a formula ϕ that are closest to a given world, which is certainly allowed in Lewis's framework. I suspect that there is an interesting class of nonrecursive causal models that can be captured in Lewis's framework, and that these will turn out to be the models that actually arise in practice.

Zhang [2012] makes some progress on this issue. He proposes two condition on causal models, which he calls *solution-ful* and *solution-conservativeness*. The former condition is easy to understand: a causal model T is solution-ful if, for every context ~u, the equations have a solution (not necessarily unique). The second condition is somewhat more complicated. T is solution-conservative if, for every context ~u, if a solution to TX~ =~x is consistent with Y~ = ~y, then every solution to TX~ =~x∧Y~ =~y is a solution to TX~ =~x. Zhang shows that a causal model satisfies these two conditions iff it satisfies analogues of all