For example, if we are trying to determine whether a forest fire was caused by lightning or an arsonist, we can take the world to be described by four random variables:
- FF for forest fire, where FF = 1 if there is a forest fire and FF = 0 otherwise;
- L for lightning, where L = 1 if lightning occurred and L = 0 otherwise;

- MD for match dropped (by arsonist), where MD = 1 if the arsonist dropped a lit match, and MD = 0 otherwise;
- E, which captures the external factors that determine whether the arsonist will drop a match, or whether lightning will strike.

The variables FF, L, and MD are endogenous, while E is exogenous. If we want to model the fact that if the arsonist drops a match or lightning strikes then a fire starts, then we would have the equation FF **= max(**L, MD); that is, the value of the random variable FF is the maximum of the values of the random variables MD and L. This equation says, among other things, that if MD = 0 and L = 1, then FF = 1. Alternatively, if we want to model the fact that a fire requires both a lightning strike and a dropped match (perhaps the wood is so wet that it needs two sources of fire to get going), then the only change in the model is that the equation for FF becomes FF **= min(**L, MD); the value of FF is the minimum of the values of MD and L. The only way that FF = 1 is if both L = 1 and MD = 1.

Formally, a *signature* S is a tuple (U, V, R), where U is a finite set of exogenous variables, V is a finite set of endogenous variables, and R associates with every variable X **∈ U ∪ V** a finite set R(X)
of possible values for X (the *range* of possible values of X). A *causal model* is a pair T = (S, F),
where S is a signature and F associates with each variable X ∈ V a function denoted FX such that FX : (×Z∈(U∪V−{X})R(Z)) → R(X). FX characterizes the value of X given the values of all the other variables in **U ∪V**. Because FX is a function, there is a unique value of X once all the other variables are set. Notice that we have such functions only for the endogenous variables. The exogenous variables are taken as given; it is their effect on the endogenous variables (and the effect of the endogenous variables on each other) that is modeled by the structural equations.

Given a causal model T = (S, F), a (possibly empty) vector X~ of variables in V, and a vector
~x of values for the variables in X~ , we can define a new causal model denoted TX~ =~x. Intuitively, this is the causal model that results when the variables in X~ are set to ~x. We can think of setting X~ to ~x as an intervention. For example, if T is the causal model for the forest fire described above, where FF **= max(**L, MD), then TL=0 is the model where the lightning definitely does not occur, so that there is a forest fire if and only if the arsonist drops a match. If T
′is the model where FF **= min(**L, MD),
then T
′L=0 is the model where there is no forest fire, since there is no lightning.

Formally, TX~ =~x = (S, F
X~ =~x}), where F
X~ =~x is identical to F except that the equation for X is replaced by the equation X = x. The model TX~ =~x describes a possible *counterfactual* situation; that is, even though, under normal circumstances, setting the exogenous variables to ~u results in the variables X~ having value ~x′ 6= ~x, this submodel describes what happens if they are set to ~x due to some "external action", the cause of which is not modeled explicitly.

In general, given a *context* ~u, that is, a setting for the exogenous variables, there may not be a unique vector of values that simultaneously satisfies all the equations in TX~ =~x; indeed, there may not be a solution at all. One special case where the equations in a causal model T are guaranteed to have