a unique solution is when there is a total ordering ≺T of the variables in V such that if X ≺T Y , then FX is independent of the value of Y ; that is, FX (. . . , y, . . .) = FX (. . . , y′**, . . .**) for all y, y′ ∈ R(Y ). In this case, T is said to be recursive or *acyclic*. Intuitively, if T is recursive, then there is no feedback; if X ≺T Y , then the value of X may affect the value of Y , but the value of Y has no effect on the value of X. It should be clear that if T is a recursive model, then, given a context ~u, there is always a unique solution to the equations in TX~ =~x, for all X~ and ~x, (We simply solve for the variables in the order given by ≺T .)
Following [Halpern 2000], I consider three successively more general classes of causal models for a given signature S (with a focus on the first two):
1. Trec(S): the class of recursive causal models over signature S;

2. Tuniq(S): the class of causal models T over S where, for all X~ ⊆ V, ~x, the equations in TX~ =~x have a unique solution for all contexts ~u;
3. T (S): the class of all causal models over S.

I often omit the signature S when it is clear from context or irrelevant, but the reader should bear in mind its important role.

Syntax and Semantics: In [Halpern 2000], a number of languages for reasoning about causality are considered. The choice of language is significant. As Galles and Pearl already point out, we cannot in any obvious way give a meaning in causal models to counterfactual implications where there is a disjunction on the left-hand side of the implication, that is formulas of the form (A ∨ A′)  B. Thus, our results effectively consider a language with no disjunction on the left-hand side of . As mentioned in the introduction, one of the results of this paper have the form "for every recursive causal model, there is a recursive causal structure that satisfies the same formulas", and vice versa. For this result to have any bite, we must choose a reasonably rich language.

In [Halpern 2000], I considered a number of languages appropriate for reasoning about causality in causal models. I briefly review two of them here. The languages are parameterized by the signature S. A
basic causal formula is one of the form [Y1 = y1**, . . . , Y**k = yk]ϕ, where ϕ is a Boolean combination of formulas of the form X = x, Y1, . . . , Yk, X are variables in V, Y1**, . . . , Y**k are distinct, and x ∈ R(X).

I typically abbreviate such a formula as [Y~ = ~y]ϕ. The special case where k = 0 is abbreviated as ϕ.

A *causal formula* is a Boolean combination of basic causal formulas. Let L
+(S) consist of all causal formulas over the signature S. (Again, I often omit the signature S if it is clear from context or not relevant.)
Roughly speaking, we can think of L
+(S) as the language that results by starting with primitive propositions of the form X = x, where X is a random variable in V and x ∈ R(X), and closing under modal operators of the form [Y~ = ~y]. The restriction to primitive propositions of this form is not a major one. Given a propositional language with primitive propositions P1**, . . . , P**n, we can define binary random variables X1**, . . . , X**n (i.e., variables whose range is {0, 1}) and identify Xi = 1 with
"Piis true". That is, as long as we can we define structural equations that characterize how a change in one primitive propositions affects the other primitive propositions, taking the primitive propositions to have the form X = x is not a major restriction.

The formula [Y~ = ~y]X = x can be interpreted as "in all possible solutions to the structural equations obtained after setting Yito yi, i = 1**, . . . , k**, and the exogenous variables to ~u, random variable X has