Axiomatizations I briefly recall some standard definitions from logic. An *axiom system* AX consists of a collection of *axioms* and *inference rules*. An axiom is a formula (in some predetermined language L), and an inference rule has the form "from ϕ1**, . . . , ϕ**k infer ψ", where ϕ1, . . . , ϕk, ψ are formulas in L. A *proof* in AX consists of a sequence of formulas in L, each of which is either an axiom in AX or follows by an application of an inference rule. A proof is said to be a *proof of the formula* ϕ if the last formula in the proof is ϕ. We say ϕ is *provable in AX*, and write AX ⊢ ϕ, if there is a proof of ϕ in AX;
similarly, we say that ϕ is *consistent with AX* if ¬ϕ is not provable in AX.

An axiom system AX is said to be *sound* for a language L with respect to a class T
′ of causal models if every formula in L provable in AX is valid with respect to T
′. AX is *complete* for L with respect to T
′if every formula in L that is valid with respect to T
′is provable in AX.

Consider the following axioms, taken from [Halpern 2000], modified slightly for the language used here:
C0. All instances of propositional tautologies in the language Luniq.

C1. $[\vec{Y}=\vec{y}](X=x)\Rightarrow-|\vec{Y}=\vec{y}|(X=x^{\prime})$, if $x,x^{\prime}\in\mathcal{R}(X),x\neq x^{\prime}$. (Equality)  C2. $\vee_{x\in\mathcal{R}(X)}[\vec{Y}=\vec{y}](X=x)$. (Definiteness)  C3. $([\vec{X}=\vec{x}](W=w)\wedge([\vec{X}=\vec{x}](Y=y))\Rightarrow[\vec{X}=\vec{x};W=w](Y=y))$. [Composition]  C4. $[X=x;\vec{W}=\vec{w}](X=x)$. (Effectiveness)
  **C.**: $[X=x;W=w](X=x)$. (**C.**: $[\bar{X}=\bar{x};W=w](Y=y)\wedge[\bar{X}=\bar{x};Y=y](W=w)$) $\Rightarrow[\bar{X}=\bar{x}](Y=y)$, if $Y\neq W$.${}^{6}$
The key axioms C3–C5 were introduced (and named) by Galles and Pearl [1998]. Perhaps most relevant to this paper is the reversibility axiom, C5. It says that if setting X~ to ~x and W to w results in Y having value y and setting X~ to ~x and Y to y results in W having value w, then Y must already have value y when we set X~ to x (and W must already have value w).

Let AXuniq(S) consist of C0–C5 and the rule of inference *modus ponens* (from ϕ and ϕ ⇒ ψ infer ψ).

Theorem 2.2 ([Halpern 2000]*) AX*uniq(S) *is a sound and complete axiomatization for* Luniq(S) with respect to Tuniq(S).

Using Lemma 2.1, it is possible to get a complete axiomatization for L
+ with respect to Tuniq(S),
simply by adding axioms for converting a formula in L
+ to an equivalent formula in Luniq. A complete axiomatization for Luniq with respect to Trec(S) is also given in [Halpern 2000]; it requires adding a somewhat complicated axiom called C6 to AXuniq that captures acyclicity. The details are not relevant for our purposes, so I do not discuss C6 further.