Finally, a complete axiomatization for L
+ with respect to T (S), the class of all causal models, is given. The axioms are similar in spirit to those in AXuniq. In particular, there is the following analogue to reversibility (where hX~ = ~xiϕ is an abbreviation for ¬[X~ = ~x]¬ϕ):
(hX~ = ~x; Y = yi(W = w ∧ Z~ = ~z) ∧ hX~ = ~x; W = wi(Y = y ∧ Z~ = ~z))
⇒ hX~ = ~xi(W = w ∧ Y = y ∧ Z~ = ~z)), where Z~ = V − (X~ ∪ {**W, Y** }).

## 2.2 Possible-Worlds Models For Counterfactuals

There have been a number of semantics for counterfactuals. I focus here on one due to Lewis [1973].

Let Φ be a finite set of primitive propositions. A *counterfactual structure* M is a tuple (Ω**, R, π**), where Ω is a finite set of *possible worlds*,
7 π is an *interpretation* that maps each possible world to a truth assignment over Φ, and R is a ternary relation over Ω. Intuitively, (**w, u, v**) ∈ R if u is as close/preferred/plausible as v when the real world is w. Let u w v be an abbreviation for (**w, u, v**) ∈ R,
and define Ωw = {u : u w v ∈ R for some v ∈ Ω}; thus, the worlds in Ωw are those that are at least as plausible as some world in Ω according to w. Define v ≺w v
′if v w v
′and v
′ 6w v. We require that w ∈ Ωw, that w be reflexive and transitive on Ωw, and that w ≺w u for all u 6= w. Thus, ≺w puts an ordering on worlds that can be viewed as characterizing "closeness to w", and w is the closest world to itself.

Let L
C(Φ) be the language formed by starting with Φ and closing off under ∧, ¬, and  (where denotes counterfactual implication). The language L
C allows arbitrary nesting of counterfactual implications. By way of contrast, the language L
+ and its sublanguages have only one level of nesting, if we think of [X~ = ~x]ϕ as (X~ = ~x)  ϕ. Let L
C 1 be the sublanguage of L
C consisting of all formulas with no nested occurrence of  (including formulas with no occurrence of  at all).

We can give semantics to formulas in L
C (and hence L
C 1
) in a counterfactual structures M =
(Ω**, R, π**) as follows. The first few clauses are standard:
- (**M, w**) |= p, when p ∈ Φ, if π(w)(p) = true.

- (M, w) |= ϕ ∧ ψ if (**M, w**) |= ϕ and (**M, w**) |= ψ.
- (**M, w**) |= ¬ϕ if it is not the case that (**M, w**) |= ϕ.

To give semantics to ϕ  ψ, assume inductively that we have already given semantics to ϕ at all worlds in M. Define closestM(w, ϕ) = {v ∈ Ωw : (**M, v**) |= ϕ and there is no world v
′such that (**M, v**′) |= ϕ and v
′ ≺w v}. Thus, closestM(**w, ϕ**) is the set of worlds closest to w where ϕ is true. (Notice that if there are no worlds where ϕ holds, then closestM(w, ϕ) = ∅.)
- (M, w) |= ϕ  ψ if (**M, v**) |= ψ for all v ∈ closestM(**w, ϕ**).