Axioms: There are a number of well-known sound and complete axiomatizations for counterfactual logic (see, e.g., [Burgess 1981; Bell 1989; Chellas 1980; Grahne 1991; Katsuno and Satoh 1991; Lewis 1971; Lewis 1973; Lewis 1974]). Here is one, based on Burgess's axiomatization, similar in spirit to the well-known KLM properties [Kraus, Lehmann, and Magidor 1990].

A0. All instances of propositional tautologies in the language L
C.

A1. ϕ  ϕ.

A2. ((ϕ  ψ1) ∧ (ϕ  ψ2)) ⇒ (ϕ  (ψ1 ∧ ψ2)).

A3. ((ϕ1  ϕ2) ∧ (ϕ1  ψ)) ⇒ ((ϕ1 ∧ ϕ2)  ψ).

A4. ((ϕ1  ψ) ∧ (ϕ2  ψ)) ⇒ ((ϕ1 ∨ ϕ2)  ψ).

A5. ¬(true  **false**).

A6. ϕ ⇒ (ψ ⇔ (ϕ  ψ)).

There are three rules of inference: modus ponens, and the following two rules:
RA1. From ϕ ⇔ ϕ
′infer (ϕ  ψ) ⇒ (ϕ
′  ψ).

RA2. From ψ ⇒ ψ
′infer (ϕ  ψ) ⇒ (ϕ  ψ
′).

A1–A4 and RA1–RA2 correspond to the KLM postulates REF (for reflexivity), AND, CM (cautious monotonicity), OR, LLE (left logical equivalence), and RW (right weakening), respectively. A5 captures the requirement that Ωw is nonempty. Finally, A6 is the axiom that makes  a counterfactual operator, and not just a "normality" or "typicality" operator (so that "normally birds have wings" becomes **bird** 
wing). Suppose that it is the case that if ϕ were true, then ψ would be true. Then if ϕ is actually true, we would expect ψ to be true. Moreover, if ϕ and ψ are both true, then it seems reasonable to assert that if ϕ were true, then ψ would be true. On the other hand, it is not in general the case that if ϕ and ψ are both true, then ϕ's are normally or typically ψ's.

In his semantics, Lewis allows there to be more than one world closest to a world w where ϕ is true
(except in the special case that ϕ is true at w; in this case, w is the unique world closest to w satisfying ϕ). By way of contrast, Stalnaker [1968] essentially assumes that for each world w and formula ϕ, there is a unique world closest to w satisfying ϕ. The standard approach to getting uniqueness is to require that w be a strict total order (whose least element is w); that is, for all worlds w
′ 6= w
′′, either w
′ ≺w w
′′ or w
′′ ≺w w
′. This assumption is captured by the following axiom:

## A7. (Φ  (Ψ1 ∨ Ψ2)) ⇒ ((Φ  Ψ1) ∨ (Φ  Ψ2)).

Let AX be the axiom system consisting of axioms A0–A6 and rules of inference RA1, RA2, and modus ponens; let AX′be AX together with the axiom A7. Let M(Φ) be the collection of all counterfactual structures over the primitive propositions in Φ (i.e., structures where π interprets formulas in Φ);
let M+(Φ) be the subset of M(Φ) consisting of all counterfactual structures where w is a total strict order. As usual, I omit the Φ when it is clear from context or irrelevant.

Theorem 2.3 [Burgess 1981] AX (resp., AX′*) is a sound and complete axiomatization for the language* Luniq with respect to M *(resp.,* M+).