# Actual Causation And The Art Of Modeling Joseph Y. Halpern And Christopher Hitchcock

## 1 Introduction

In *The Graduate***, Benjamin Braddock (Dustin Hoffman) is told that the future can**
be summed up in one word: "Plastics". One of us (Halpern) recalls that in roughly 1990, Judea Pearl told him that the future was in causality. Pearl's own research was largely focused on causality in the years after that; his seminal **contributions** are widely known. We were among the many influenced by his work. We discuss one aspect of it, *actual causation***, in this article, although a number of our comments** apply to causal modeling more generally.

Pearl introduced a novel account of actual causation in Chapter **10 of** *Causality*,
which was later revised in collaboration with one of us [Halpern and Pearl 2005]. In some ways, Pearl's approach to actual causation can be seen as **a contribution to**
the philosophical project of trying to analyze actual causation in terms of counterfactuals, a project associated most strongly with David Lewis [1973a]. But Pearl's account was novel in at least two important ways. The first was his use of *structural equations* **as a tool for modeling causality. In the philosophical literature,**
causal structures were often represented using so-called *neuron diagrams***, but these** are not (and were never intended to be) all-purpose representational tools. (See
[Hitchcock 2007b] for a detailed discussion of the limitations of neuron diagrams.)
We believe that the lack of a more adequate representational tool **had been a serious obstacle to progress. Second, while the philosophical literature on causality**
has focused almost exclusively on actual causality, for Pearl, actual causation was a rather specialized topic within the study of causation, peripheral **to many issues** involving causal reasoning and inference. Thus, Pearl's work placed **the study of** actual causation within a much broader context.

The use of structural equations as a model for causal relationships was well known long before Pearl came on the scene; it seems to go back to the work of Sewall Wright in the 1920s (see [Goldberger 1972] for a discussion). **However, the** details of the framework that have proved so influential are due to **Pearl. Besides** the Halpern-Pearl approach mentioned above, there have been a **number of other** closely-related approaches for using structural equations to model actual causation; see, for example, [Glymour and Wimberly 2007; Hall 2007; Hitchcock 2001; Hitchcock 2007a; Woodward 2003]. The goal of this paper is to look more carefully at the modeling of causality using structural equations. For definiteness, we use the arXiv:1106.2652v1 [cs.AI] 14 Jun 2011 23