than the right side, which is how it would have entered had B**'s shot been the lethal**
one). The side from which the shot entered is the relevant random variable in this case. Note that the random variable may involve temporal evidence (if Y **'s shot**
had been the lethal one, the death would have occurred a few seconds later), but it certainly does not have to.

## 4 The Choice Of Variables

A modeler has considerable leeway in choosing which variables to include **in a model.**
Nature does not provide a uniquely correct set of variables. Nonetheless, there are a number of considerations that guide variable selection. While these will not usually suffice to single out one choice of variables, they can provide a framework for the rational evaluation of models, including resources for motivating and defending certain choices of variables, and criticizing others.

The problem of choosing a set of variables for inclusion in a model has many dimensions. One set of issues concerns the question of how many variables to include in a model. If the modeler begins with a set of variables, how can **she know**
whether she should add additional variables to the model? Given that **it is always** possible to add additional variables, is there a point at which the model contains
"enough" variables? Is it ever possible for a model to have "too many" variables? Can the addition of further variables ever do positive harm to a model?

Another set of issues concerns the values of variables. Say that variable X′**is a**
refinement of X if, for each value x in the range of X**, there is some subset** S of the range of X′such that X = x just in case X′is in S**. When is it appropriate or**
desirable to replace a variable with a refinement? Can it ever lead to problems if a variable is too fine-grained? Similarly, are there considerations that **would lead us**
to prefer a model that replaced X with a new variable X′′**, whose range is a proper**
subset or superset of the range of X?

Finally, are there constraints on the set of variables in a model over **and above**
those we might impose on individual variables? For instance, can the choice to include a particular variable X **within a model require us to include another variable**
Y **, or to exclude a particular variable** Z?

While we cannot provide complete answers to all of these questions, **we believe**
a good deal can be said to reduce the arbitrariness of the choice of **variables. The** most plausible way to motivate guidelines for the selection of variables **is to show**
how inappropriate choices give rise to systems of equations that are inaccurate, misleading, or incomplete in their predictions of observations and interventions. In the next three subsections, we present several examples to show how such considerations can be brought to bear on the problem of variable choice.

## 4.1 The Number Of Variables

We already saw in Example 3 that it is important to choose the variables **correctly.**
Adding more variables can clearly affect whether A is a cause of B. When is it