about causality are best addressed by dealing with the methodological problem of constructing a model that correctly describes the effects of interventions in a way that is not misleading or ambiguous.

A slightly different way in which one variable may constrain the values that another may take is by its implicit presuppositions. For example, a counterfactual theory of causation seems to have the somewhat counterintuitive **consequence that** one's birth is a cause of one's death. This sounds a little odd. If Jones **dies suddenly** one night, shortly before his 80th birthday, the coroner's inquest **is unlikely to list** "birth" as among the causes of his death. Typically, when we investigate the causes of death, we are interested in what makes the difference between a **person's dying**
and his surviving. So our model might include a variable D such D **= 1 holds if** Jones dies shortly before his 80th birthday, and D **= 0 holds if he continues to** live. If our model also includes a variable B**, taking the value 1 if Jones is born, 0** otherwise, then there simply is no value that D would take if B = 0. Both D = 0 and D = 1 implicitly presuppose that Jones was born (i.e., B **= 1). Our conclusion**
is that if we have chosen to include a variable such as D **in our model, then we**
cannot conclude that Jones' birth is a cause of his death!

## 4.3 Dependence And Independence

Lewis [1986a] added a constraint to his counterfactual theory of **causation. In order**
for event c to be a cause of event e**, the two events cannot be logically related.**
Suppose for instance, that Martha says "hello" loudly. If she had not said "hello", then she certainly could not have said "hello" loudly. But her saying "hello" is not a cause of her saying "hello" loudly. The counterfactual dependence results from a logical, rather than a causal, relationship between the two events.

We must impose a similar constraint upon causal models. Values of different variables should not correspond to events that are logically related. But now, rather than being an *ad hoc* **restriction, it has a clear rationale. For suppose that we had**
a model with variable H1 and H2, where H1 **represents "Martha says 'hello' " (i.e.,**
H1 = 1 if Martha says "hello" and H1 = 0 otherwise), and H2 **represents "Martha**
says 'hello' loudly". The intervention H1 = 0∧ H2 **= 1 is meaningless; it is logically**
impossible for Martha not to say "hello" and to say ''hello" loudly.

We doubt that any careful modeler would choose variables that have logically related values. However, the converse of this principle, that the different values of any particular variable *should* **be logically related (in fact, mutually exclusive),** is less obvious and equally important. Consider Example 3. While, in the actual context, Billy's rock will hit the bottle just in case Suzy's doesn't, this **is not a** necessary relationship. Suppose that, instead of using two variables SH and BH ,
we try to model the scenario with a variable H **that takes the value 1 if Suzy's rock**
hits, and and 0 if Billy's rock hits. The reader can verify that, in this model, there is no contingency such that the bottle's shattering depends upon Suzy's throw. The problem, as we said, is that H = 0 and H **= 1 are** not mutually exclusive; there are