
## 5 Dealing With Normality And Typicality

While the definition of causality given in Definition 1 works well in many cases, it does not always deliver answers that agree with (most people's) intuition. Consider the following example, taken from Hitchcock [2007a], based on an example due to Hiddleston [2005]. EXAMPLE 6. Assassin is in possession of a lethal poison, but has a last-minute change of heart and refrains from putting it in Victim's coffee. Bodyguard puts antidote in the coffee, which would have neutralized the poison had there been any. Victim drinks the coffee and survives. Is Bodyguard's putting in **the antidote** a cause of Victim surviving? Most people would say no, but according to the preliminary HP definition, it is. For in the contingency where Assassin puts in the poison, Victim survives iff Bodyguard puts in the antidote.

Example 6 illustrates an even deeper problem with Definition 1. The structural equations for Example 6 are *isomorphic* **to those in the forest-fire example,** provided that we interpret the variables appropriately. Specifically, take the endogenous variables in Example 6 to be A **(for "assassin does not put in poison"),**
B (for "bodyguard puts in antidote"), and VS **(for "victim survives"). Then** A, B,
and VS satisfy exactly the same equations as L, ML, and F**, respectively. In the**
context where there is lightning and the arsonists drops a lit match, **both the lightning and the match are causes of the forest fire, which seems reasonable. But here**
it does not seem reasonable that Bodyguard's putting in the antidote is a cause. Nevertheless, any definition that just depends on the structural equations is bound to give the same answers in these two examples. (An example illustrating the same phenomenon is given by Hall [2007].) This suggests that there must be **more to** causality than just the structural equations. And, indeed, the final HP definition of causality allows certain contingencies to be labeled as "unreasonable" or "too farfetched"; these contingencies are then not considered in AC2(a) or AC2(b). As discussed by Halpern [2008], there are problems with the HP account; we present here the approach used in [Halpern 2008] for dealing with these problems, which involves assuming that an agent has, in addition to a theory of causality (as modeled by the structural equations), a theory of "normality" or "typicality". (The need to consider normality was also stressed by Hitchcock [2007a] and Hall [2007], and further explored by Hitchcock and Knobe [2009].) This theory would include statements like "typically, people do not put poison in coffee" and "typically doctors do not treat patients to whom they are not assigned". There are many ways of giving semantics to such typicality statements (e.g., [Adams 1975; Kraus, **Lehmann, and** Magidor 1990; Spohn 2009]). For definiteness, we use *ranking functions* **[Spohn** 2009] here.

Take a *world* **to be a complete description of the values of all the random variables.**
we assume that each world has associated with it a *rank***, which is just a natural**
number or ∞. Intuitively, the higher the rank, the less "normal" or "typical" the