and Magidor [1990] with the structural-equation model. Moreover, **doing this leads**
to a straightforward solution to the problem above. The idea is that, when showing that if A hadn't happened then B **would not have happened, we consider only**
contingencies that are at least as normal as the actual world. For **example, if** someone typically leaves work at 5:30 PM and arrives home at 6, but, due to unusually bad traffic, arrives home at 6:10, the bad traffic is typically viewed as the cause of his being late, not the fact that he left at 5:30 (rather than 5:20).

But once we add defaults to the model, the problem of justifying the **model becomes even more acute. We not only have to justify the structural equations and the**
choice of variables, but also the default theory. The problem is exacerbated by the fact that default and "normality" have a number of interpretations. Among other things, they can represent moral obligations, societal conventions, prototypicality information, and statistical information. All of these interpretations are relevant to understanding causality; this makes justifying default choices somewhat subtle.

The rest of this paper is organized as follows. In Sections 2 and 3, we **review the**
notion of causal model and the HP definition of actual cause; most **of this material is**
taken from [Halpern and Pearl 2005]. In Section 4, we discuss some issues involved in the choice of variables in a model. In Section 5, we review the approach of
[Halpern 2008] for adding considerations of normality to the HP framework, and discuss some modeling issues that arise when we do so. We conclude in Section 6.

## 2 Causal Models

In this section, we briefly review the HP definition of causality. The description of causal models given here is taken from [Halpern 2008], which in turn is based on that of [Halpern and Pearl 2005].

The HP approach assumes that the world is described in terms of random variables and their values. For example, if we are trying to determine whether a forest fire was caused by lightning or an arsonist, we can take the world to be described by three random variables:
- F for forest fire, where F = 1 if there is a forest fire and F **= 0 otherwise;**

- L for lightning, where L = 1 if lightning occurred and L **= 0 otherwise;**
- ML for match (dropped by arsonist), where ML **= 1 if the arsonist drops a lit**
match, and ML **= 0 otherwise.**
Some random variables may have a causal influence on others. This influence is modeled by a set of *structural equations***. For example, to model the fact that** if either a match is lit or lightning strikes, then a fire starts, we could use the random variables ML, F, and L as above, with the equation F **= max(**L, ML).

(Alternately, if a fire requires both causes to be present, the equation for F **becomes**
F = min(L, ML**).) The equality sign in this equation should be thought of more like**
an assignment statement in programming languages; once we set the values of F