sensors are sullied with uncertainty, due to operational conditions of observations (concealment, jamming, dissemination, etc.). In this paper, we could note that the term "uncertainty" is intended to cover a variety of forms of incomplete knowledge, including incompleteness, vagueness, ambiguity, and others. Uncertainty can be due to measuring errors made by physical sensors (human or electronic). For example, a radar can observe the speed of a vehicle with an error of + or - 3 Km/h. At level 1, it should be necessary to enable the representation of knowledge such as: "Possibility of existence of a regiment position (x,y,t)". There is here a doubt concerning the existence of the observed entity. At level 2, there could be uncertain relations between entities. For instance, "do two military aircrafts maintain a communication?". Finally, uncertainty is also ubiquitous in higher levels where the assessment of impact (including threat) is always associated to a certain degree of confidence. 

As previously shown, uncertainty is inherent to data. 

However, uncertainty also naturally occurs in the fusion process itself. Issues related to uncertainty arise in case the set of information acquired from multiple sources about the same fact is inconsistent, or - more generally - in case that multiple information sources attribute different grades of belief to the same statement. If the user/application is not able to decide in favor of a single alternative (due to insufficient trust in the respective information sources), the aggregated statement resulting from the fusion of multiple statements is typically uncertain. The result needs to reflect and weight the different information inputs appropriately, which typically leads to uncertainty. 

This paper is organized as follows. In the second section it begins to establish the limitation of traditional ontology formalism in the field of uncertainty representation. Then, it discusses the various ways that have been chosen to represent uncertainty within ontologies, by making a state of art of the most known approaches and associated tools. 

In section 3, we will briefly remind what make the Belief Theory a so appealing theory to represent uncertainty within our Data Fusion Applications. Consequently, we will present the ontology that we have built, called DS-Ontology, according to the Dempster-Shafer model, which helps to construct uncertain aspects into any specific domain ontologies. The section will then present the Java application we developed in order to reason formally on an ontology that imports the DS-Ontology, thanks to Jena [5], a Java framework for building Semantic Web applications. 

## Ii. Existing Approaches For Uncertainty Representation Within Ontologies

We will focus here naturally on approaches that directly deal with Semantic languages, and especially OWL. Moreover, we will present some open source tools that we have been able to find out and that permit in some way to represent uncertainty in ontology. We will organize this survey regarding their underlying theory. But first of all, let's remind why traditional ontologies cannot, on their own, answer this uncertainty issue. A. *Limit of traditional ontologies for uncertainty* representation One of the major limitations of traditional ontology formalisms is the lack of consistent support for uncertainty, reliability and imprecision. As a matter of fact, ontologies currently designed contain only concepts and relations that describe asserted facts about the world. This means that the ontology itself is not uncertain in nature, but rather presents an a priori model of the world, which has to be taken as true by its users. However, in many cases, it is preferable to store a piece of information even imprecise and uncertain rather than to interpret its contents in a restrictive manner, which will lead to store erroneous pieces of information. 

There is currently no standard mechanism for interoperable description and exchange of uncertain information over ontologies and even less a standard to reason on this type of information. However, many researchers are currently trying to enhance ontological capabilities concerning this field. As a matter of fact, the requirement for representation has led the World Wide Web Consortium (W3C) to set up the Uncertainty Reasoning for the World Wide Web Incubator Group in 2007 2. It delivered its final report in March 2008, which exposed mainly the different reasoning challenges and the various use cases for the need of uncertainty representation in the Semantic Web. 

## B. Probabilistic Approaches

Probability domain is surely the most known mathematical theory dealing with uncertainty. In brief, it provides a mathematically sound representation language and formal calculus for rational degrees of belief. 

Firstly, some existing tools are based on this theory and more specifically on the Bayesian networks. Bayesian networks (BN) are a powerful probabilistic graphical model to represent a set of random variables and their conditional independencies. Bayesian networks are directed acyclic graphs. The arcs point the direction from the cause to the consequence. BayesOWL [6] is one proposal to model uncertainty in OWL ontologies through BN. It is a mechanism to express OWL ontologies as BN by adding a second ontology to this translation which declares the probabilistic relationships. The advantage is that neither OWL nor ontologies defined in OWL need to be modified. 

It is used to quantify the degree of the overlap or inclusion between two concepts. However, there are important limitations considering the translation of ontologies. As a matter of fact, it does not take into account neither the properties represented by OWL, the instances nor the specific datatypes. 

2further details on: http://www.w3.org/2005/Incubator/urw3/